/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.codegen.analysis;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.references.ValRef;
import org.simantics.scl.compiler.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.codegen.values.SCLConstant;
import org.simantics.scl.compiler.common.names.Name;

public class LoopAnalysis {
    private static final Name BUILD = Name.create("Prelude", "build");

    private static boolean isLoopingBlock(SSABlock block) {
        THashSet handled = new THashSet();
        SSABlock[] sSABlockArray = block.getExit().getSuccessors();
        int n = sSABlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            SSABlock succBlock = sSABlockArray[n2];
            if (LoopAnalysis.isLoopingBlock(block, (THashSet<SSABlock>)handled, succBlock)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isLoopingBlockWithBreaker(SSABlock block, SSABlock breaker) {
        SSAFunction function = block.getParent();
        if (function == block.getParent()) {
            THashSet handled = new THashSet();
            handled.add((Object)breaker);
            SSABlock[] sSABlockArray = block.getExit().getSuccessors();
            int n = sSABlockArray.length;
            int n2 = 0;
            while (n2 < n) {
                SSABlock succBlock = sSABlockArray[n2];
                if (LoopAnalysis.isLoopingBlock(block, (THashSet<SSABlock>)handled, succBlock)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (LoopAnalysis.isLoopingBlock(block)) {
            return false;
        }
        Val functionTarget = function.getTarget();
        if (functionTarget.hasMoreThanOneOccurences()) {
            return false;
        }
        ValRef occ = functionTarget.getOccurrence();
        if (occ == null) {
            return false;
        }
        ValRefBinder occParent = occ.getParent();
        if (!(occParent instanceof LetApply)) {
            return true;
        }
        LetApply apply = (LetApply)occParent;
        if (!LoopAnalysis.isAppliedAtMostOnce(apply, occ, function)) {
            return true;
        }
        return LoopAnalysis.isLoopingBlockWithBreaker(apply.getParent(), breaker);
    }

    private static boolean isAppliedAtMostOnce(LetApply apply, ValRef funRef, SSAFunction function) {
        ValRef applyFunctionRef = apply.getFunction();
        if (funRef == applyFunctionRef) {
            return apply.getParameters().length == function.getArity();
        }
        Val applyFunction = applyFunctionRef.getBinding();
        if (!(applyFunction instanceof SCLConstant)) {
            return false;
        }
        Name name = ((SCLConstant)applyFunction).getName();
        return name == BUILD;
    }

    private static boolean isLoopingBlock(SSABlock originalBlock, THashSet<SSABlock> handled, SSABlock block) {
        if (!handled.add((Object)block)) {
            return false;
        }
        if (block == originalBlock) {
            return true;
        }
        SSABlock[] sSABlockArray = block.getExit().getSuccessors();
        int n = sSABlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            SSABlock succBlock = sSABlockArray[n2];
            if (LoopAnalysis.isLoopingBlock(originalBlock, handled, succBlock)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

