/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.expressions.datatype;

import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class DatatypeConversion {
    private static final Datatype.Visitor<Type> conversionVisitor = new Datatype.Visitor<Type>(){

        public Type visit(ArrayType b) {
            return Types.apply((Type)Types.LIST, (Type)((Type)b.componentType.accept((Datatype.Visitor)this)));
        }

        public Type visit(BooleanType b) {
            return Types.BOOLEAN;
        }

        public Type visit(DoubleType b) {
            return Types.DOUBLE;
        }

        public Type visit(FloatType b) {
            return Types.FLOAT;
        }

        public Type visit(IntegerType b) {
            return Types.INTEGER;
        }

        public Type visit(ByteType b) {
            return Types.BYTE;
        }

        public Type visit(LongType b) {
            return Types.LONG;
        }

        public Type visit(OptionalType b) {
            return Types.apply((Type)Types.MAYBE, (Type)((Type)b.componentType.accept((Datatype.Visitor)this)));
        }

        public Type visit(RecordType b) {
            throw new UnsupportedOperationException();
        }

        public Type visit(StringType b) {
            return Types.STRING;
        }

        public Type visit(UnionType b) {
            throw new UnsupportedOperationException();
        }

        public Type visit(VariantType b) {
            throw new UnsupportedOperationException();
        }

        public Type visit(MapType b) {
            throw new UnsupportedOperationException();
        }
    };

    public static Type convertDatatypeToType(Datatype dataType) {
        return (Type)dataType.accept(conversionVisitor);
    }
}

