/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.Exports;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.manager.ExportManager;
import org.simantics.export.core.manager.ExportPlan;
import org.simantics.export.core.manager.ExportWizardResult;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.export.ui.ContentSelectionPage;
import org.simantics.export.ui.OptionsPage;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportCoreWizard
extends Wizard
implements IExportWizard {
    ExportContext ctx;
    List<String> selection;
    ContentSelectionPage contentPage;
    OptionsPage optionsPage;

    public ExportCoreWizard() {
        this.setWindowTitle("Export PDF files");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.ctx = ExportContext.create((ISessionContext)SimanticsUI.getSessionContext(), (IStructuredSelection)selection);
            this.ctx.eep = Exports.createExtensionPoint();
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public boolean performFinish() {
        ExportManager em;
        ExportPlan plan;
        boolean[] canceled;
        block15: {
            if (this.getContainer().getCurrentPage() == this.contentPage) {
                this.contentPage.validatePage();
                this.optionsPage.update(this.contentPage.getContentSelection());
            }
            canceled = new boolean[1];
            try {
                this.contentPage.savePrefs();
                this.optionsPage.savePrefs();
            }
            catch (ExportException e) {
                e.printStackTrace();
                ExceptionUtils.logError((Throwable)e);
            }
            plan = new ExportPlan();
            ExportWizardResult wizardResult = this.optionsPage.getOutput();
            em = new ExportManager(wizardResult.options, this.ctx);
            wizardResult.createPlan(this.ctx, plan);
            System.out.println(wizardResult);
            List exportProblems = em.validate(this.ctx, plan);
            if (exportProblems.isEmpty()) break block15;
            CollectionUtils.unique((List)exportProblems);
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            String str = CollectionUtils.toString((Collection)exportProblems, (String)"\n");
            cp.setErrorMessage(str);
            return false;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)plan.label, (int)1000000);
                    try {
                        try {
                            em.execute(ExportCoreWizard.this.ctx, (IProgressMonitor)mon.newChild(1000000, 0), plan);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        canceled[0] = monitor.isCanceled();
                        monitor.done();
                    }
                }
            });
            try {
                this.ctx.store.flush();
            }
            catch (BackingStoreException e) {
                ErrorLogger.defaultLogError((String)"Failed to persist wizard preferences.", (Throwable)e);
                ExceptionUtils.logError((Throwable)e);
            }
        }
        catch (InvocationTargetException e) {
            ExportException ee;
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof ExportException && t.getCause() != null && (ee = (ExportException)t).getCause() != null) {
                t = ee.getCause();
            }
            if (canceled[0]) {
                cp.setErrorMessage("Export canceled.");
            } else if (t instanceof IOException) {
                ErrorLogger.defaultLogError((String)"An I/O problem occurred while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("An I/O problem occurred while exporting the model.\nMessage: " + t.getMessage());
            } else {
                ErrorLogger.defaultLogError((String)"Unexpected exception while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("Unexpected exception while exporting the model. See error log for details.\nMessage: " + t.getMessage());
            }
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
        catch (ExportException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        try {
            this.contentPage = new ContentSelectionPage(this.ctx);
            this.optionsPage = new OptionsPage(this.ctx);
            this.addPage((IWizardPage)this.contentPage);
            this.addPage((IWizardPage)this.optionsPage);
        }
        catch (ExportException e) {
            e.printStackTrace();
            ExceptionUtils.logError((Throwable)e);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.optionsPage) {
            try {
                this.optionsPage.getOutput();
            }
            catch (ExportException e) {
                return null;
            }
        }
        if (page == this.contentPage) {
            this.contentPage.validatePage();
            this.optionsPage.update(ExporterUtils.sortContent(this.contentPage.getContentSelection()));
        }
        return super.getNextPage(page);
    }
}

