/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.profile.view.ResourcePair;
import org.simantics.diagram.profile.view.SCLEditorComposite;
import org.simantics.diagram.profile.view.SCLInput;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class ProfileSelectionProcessor
implements SelectionProcessor<Object, ReadGraph> {
    public Collection<?> process(Object selection, ReadGraph g) {
        try {
            Resource object = (Resource)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
            ResourcePair object2 = (ResourcePair)((Object)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, ResourcePair.class));
            return this.processInternal(g, object, object2, selection);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<?> processInternal(ReadGraph g, Resource object, ResourcePair pair, Object selection) throws DatabaseException {
        ArrayList<Object> inputs = new ArrayList<Object>();
        this.parseResourceInput(g, object, pair, inputs);
        return this.accept(inputs);
    }

    Collection<ComparableTabContributor> accept(Collection<?> inputs) {
        TreeSet<ComparableTabContributor> result = new TreeSet<ComparableTabContributor>();
        for (Object input : inputs) {
            if (!(input instanceof SCLInput)) continue;
            SCLInput configurationInput = (SCLInput)((Object)input);
            result.add(new ComparableTabContributor((PropertyTabContributor)new SCLEditorComposite(), (double)configurationInput.priority, configurationInput.getDatum(), configurationInput.text));
        }
        return result;
    }

    private void parseResourceInput(ReadGraph g, Resource part, ResourcePair pair, Collection<Object> inputs) throws DatabaseException {
        this.getGroups(g, part, pair, inputs);
    }

    void getGroups(ReadGraph g, Resource r, ResourcePair p, Collection<Object> result) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        if (r != null && g.isInstanceOf(r, dr.SCLGroup)) {
            result.add((Object)new SCLInput(r, 1, "SCL Group"));
        }
        if (r != null && g.isInstanceOf(r, dr.SCLTextStyle)) {
            result.add((Object)new SCLInput(r, 2, "SCL Text Style"));
        }
        if (p != null && g.isInstanceOf(p.getSecond(), dr.GroupStyleProfileEntry)) {
            Resource style;
            Resource group = g.getPossibleObject(p.getSecond(), dr.ProfileEntry_HasGroup);
            if (group != null && g.isInstanceOf(group, dr.SCLGroup)) {
                result.add((Object)new SCLInput(group, 1, "SCL Group"));
            }
            if ((style = g.getPossibleObject(p.getSecond(), dr.ProfileEntry_HasStyle)) != null && g.isInstanceOf(style, dr.SCLTextStyle)) {
                result.add((Object)new SCLInput(style, 2, "SCL Text Style"));
            }
        }
    }
}

