/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import java.util.Collection;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.view.ResourcePair;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.request.ProfileActiveEntryResources;
import org.simantics.scenegraph.profile.request.ProfileEntryResources;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileCheckContributor
implements CheckedStateRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(ResourcePair.class);
    }

    public CheckedState getCheckedState(ReadGraph graph, Object parent) throws DatabaseException {
        ResourcePair entry = (ResourcePair)((Object)parent);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(entry.getSecond(), DIA.Profile)) {
            Resource list = graph.getPossibleObject(entry.getSecond(), DIA.HasEntries);
            Collection activeEntries = (Collection)graph.syncRequest((Read)new ProfileActiveEntryResources(entry.getFirst(), list));
            if (activeEntries.isEmpty()) {
                return CheckedState.NOT_CHECKED;
            }
            Collection entries = (Collection)graph.syncRequest((Read)new ProfileEntryResources(entry.getFirst(), list));
            return entries.equals(activeEntries) ? CheckedState.CHECKED : CheckedState.GRAYED;
        }
        if (graph.isInstanceOf(entry.getSecond(), DIA.ProfileEntry) && graph.hasStatement(entry.getFirst(), SIMU.IsActive, entry.getSecond())) {
            return CheckedState.CHECKED;
        }
        return CheckedState.NOT_CHECKED;
    }
}

