/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.graph.impl.InputSourceListener;
import org.simantics.browsing.ui.graph.impl.ObservableInputSource;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSessionContextInputSource;
import org.simantics.db.Disposable;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.HasStatementSubject;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.AsyncRead;
import org.simantics.utils.ObjectUtils;

public class ActiveRuntimeDiagramInputSource
implements WorkbenchSessionContextInputSource,
ObservableInputSource,
IPartListener,
Disposable {
    protected IPartService service;
    protected IEditorPart activeEditor;
    protected Resource activeRuntimeDiagram;
    protected InputSourceListener listener;

    public void init(IWorkbenchSite site, IWorkbenchPart part) {
        this.attachToWorkbench();
    }

    protected void attachToWorkbench() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.service = window.getPartService();
        this.service.addPartListener((IPartListener)this);
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null) {
            this.editorActivated(activeEditor);
        }
    }

    public void dispose() {
        if (this.service != null) {
            this.service.removePartListener((IPartListener)this);
        }
        this.service = null;
        this.activeEditor = null;
        this.activeRuntimeDiagram = null;
        this.listener = null;
    }

    protected void fireIfInputChanged(Object oldSelection, Object newSelection) {
        InputSourceListener l = this.listener;
        if (l != null && !ObjectUtils.objectEquals((Object)oldSelection, (Object)newSelection)) {
            l.inputChanged((SessionContextInputSource)this);
        }
    }

    public Object get(ISessionContext ctx) {
        return this.activeRuntimeDiagram != null ? this.activeRuntimeDiagram : GraphExplorer.EMPTY_INPUT;
    }

    public IWorkbenchPart getProvider() {
        return this.activeEditor;
    }

    public void setListener(InputSourceListener listener) {
        this.listener = listener;
    }

    protected void editorActivated(IEditorPart part) {
        block8: {
            Session session = Simantics.peekSession();
            Resource resource = (Resource)part.getAdapter(Resource.class);
            if (session != null) {
                try {
                    if (resource != null) {
                        Boolean isRuntimeDiagram = (Boolean)session.syncRequest(Queries.isInstanceOf((Resource)resource, (String)"http://www.simantics.org/Diagram-2.2/RuntimeDiagram"));
                        if (isRuntimeDiagram.booleanValue()) {
                            this.activeEditor = part;
                            this.changeInput(resource);
                        } else {
                            Boolean stillExists = (Boolean)session.syncRequest((AsyncRead)new HasStatementSubject(resource));
                            if (!stillExists.booleanValue()) {
                                this.changeInput(null);
                            }
                        }
                        break block8;
                    }
                    this.changeInput(null);
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            } else {
                this.changeInput(null);
            }
        }
    }

    private boolean allEditorsClosed(IEditorPart forWindowOfPart) {
        IWorkbenchPage[] iWorkbenchPageArray = forWindowOfPart.getEditorSite().getWorkbenchWindow().getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] editors = page.getEditorReferences();
            if (editors.length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void activeEditorClosed() {
        if (this.allEditorsClosed(this.activeEditor)) {
            this.changeInput(null);
        }
    }

    private void changeInput(Resource newInput) {
        Resource oldInput = this.activeRuntimeDiagram;
        this.activeRuntimeDiagram = newInput;
        this.fireIfInputChanged(oldInput, newInput != null ? newInput : GraphExplorer.EMPTY_INPUT);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof EditorPart) {
            this.editorActivated((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.activeEditor) {
            this.activeEditorClosed();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

