/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.simantics.fastlz.LZ4Java;
import org.simantics.fastlz.impl.DecompressingInputStream;

public class LZ4JavaInputStream
extends DecompressingInputStream {
    public LZ4JavaInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZ4JavaInputStream(FileInputStream stream) {
        super(stream);
    }

    public LZ4JavaInputStream(InputStream stream, ReadableByteChannel channel) {
        super(stream, channel);
    }

    @Override
    public void decompress(ByteBuffer compressed, int compressedOffset, int compressedSize, ByteBuffer uncompressed, int uncompressedOffset, int uncompressedSize) throws IOException {
        int decompressed = LZ4Java.decompress(compressed.array(), 0, compressedSize, uncompressed.array(), 0, uncompressedSize);
        if (decompressed != uncompressedSize) {
            throw new IOException("decompressed " + decompressed + " bytes when " + uncompressedSize + " bytes were expected.");
        }
    }
}

