/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.simantics.fastlz.ARCHType;
import org.simantics.fastlz.OSType;

public class OS {
    public static File copyResource(URL url, File targetFile) throws IOException, FileNotFoundException {
        File file;
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int read;
            if (targetFile.exists()) {
                targetFile.delete();
            }
            is = url.openStream();
            byte[] buffer = new byte[16384];
            os = new FileOutputStream(targetFile);
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.close();
            is.close();
            file = targetFile;
        }
        catch (Throwable throwable) {
            OS.uncheckedClose(os);
            OS.uncheckedClose(is);
            throw throwable;
        }
        OS.uncheckedClose(os);
        OS.uncheckedClose(is);
        return file;
    }

    public static File extractLib(URL libURL, String libName) throws FileNotFoundException, IOException {
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            throw new NullPointerException("java.io.tmpdir property is null");
        }
        File tmpDir = new File(tmpDirStr);
        File libFile = new File(tmpDir, libName);
        return OS.copyResource(libURL, libFile);
    }

    public static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String formOsArchSuffix() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        OSType os = OSType.calculate();
        ARCHType arch = ARCHType.calculate();
        if (os == OSType.UNKNOWN) {
            throw new UnsatisfiedLinkError("unknown OS '" + osName + "' cannot load native fastlz library");
        }
        if (arch == ARCHType.UNKNOWN) {
            throw new UnsatisfiedLinkError("unknown architecture '" + osArch + "' cannot load native fastlz library");
        }
        String lib = "";
        block0 : switch (os) {
            case APPLE: {
                lib = String.valueOf(lib) + "-darwin";
                switch (arch) {
                    case PPC: {
                        lib = String.valueOf(lib) + "-ppc";
                        break block0;
                    }
                    case PPC_64: {
                        lib = String.valueOf(lib) + "-ppc_64";
                        break block0;
                    }
                    case X86: {
                        lib = String.valueOf(lib) + "-x86";
                        break block0;
                    }
                    case X86_64: {
                        lib = String.valueOf(lib) + "-x86_64";
                        break block0;
                    }
                }
                throw new UnsatisfiedLinkError("Unsupported architecture for Apple OS: " + osArch);
            }
            case LINUX: {
                lib = String.valueOf(lib) + "-linux";
                switch (arch) {
                    case X86: {
                        lib = String.valueOf(lib) + "-x86";
                        break block0;
                    }
                    case X86_64: {
                        lib = String.valueOf(lib) + "-x86_64";
                        break block0;
                    }
                }
                throw new UnsatisfiedLinkError("Unsupported architecture for Linux OS: " + osArch);
            }
            case SUN: {
                lib = String.valueOf(lib) + "-sun";
                switch (arch) {
                    case SPARC: {
                        lib = String.valueOf(lib) + "-sparc";
                        break block0;
                    }
                    case X86_64: {
                        lib = String.valueOf(lib) + "-x86_64";
                        break block0;
                    }
                }
                throw new UnsatisfiedLinkError("Unsupported architecture for Sun OS: " + osArch);
            }
            case WINDOWS: {
                lib = String.valueOf(lib) + "-windows";
                switch (arch) {
                    case X86: {
                        lib = String.valueOf(lib) + "-x86";
                        break block0;
                    }
                    case X86_64: {
                        lib = String.valueOf(lib) + "-x86_64";
                        break block0;
                    }
                }
                throw new UnsatisfiedLinkError("Unsupported architecture for Windows: " + osArch);
            }
            default: {
                throw new UnsatisfiedLinkError("Unsupported operating system: " + (Object)((Object)os));
            }
        }
        return lib;
    }

    public static String resolveLibName() {
        String lib = "fastlz";
        lib = System.mapLibraryName(String.valueOf(lib) + OS.formOsArchSuffix());
        return lib;
    }
}

