/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.simantics.fastlz.LZ4;
import org.simantics.fastlz.impl.CompressingOutputStream;

public class LZ4OutputStream
extends CompressingOutputStream {
    public LZ4OutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZ4OutputStream(FileOutputStream stream) {
        super(stream);
    }

    public LZ4OutputStream(OutputStream stream, WritableByteChannel channel) {
        super(stream, channel);
    }

    @Override
    protected int compressBound(int inputSize) {
        return LZ4.compressBound(inputSize);
    }

    @Override
    protected int compress(ByteBuffer uncompressed, int uncompressedOffset, int uncompressedSize, ByteBuffer compressed, int compressedOffset) throws IOException {
        return LZ4.compressBuffer(uncompressed, uncompressedOffset, uncompressedSize, compressed, compressedOffset);
    }

    @Override
    protected ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }
}

