/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class CompressingOutputStream
extends OutputStream {
    protected static final int BLOCK_SIZE = 0x100000;
    protected OutputStream stream;
    protected WritableByteChannel channel;
    protected ByteBuffer compressed;
    protected byte[] compressedArray;
    protected ByteBuffer uncompressed;
    protected IntBuffer header;
    protected int bytes = 0;

    public CompressingOutputStream(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public CompressingOutputStream(FileOutputStream stream) {
        this(stream, stream.getChannel());
    }

    public CompressingOutputStream(OutputStream stream) {
        this(stream, null);
    }

    public CompressingOutputStream(OutputStream stream, WritableByteChannel channel) {
        this.stream = stream;
        this.channel = channel;
        this.uncompressed = this.allocateBuffer(0x100000);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.uncompressed.remaining() == 0) {
            this.flushBuffer();
        }
        this.uncompressed.put((byte)b);
        ++this.bytes;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bytes += len;
        while (len > 0) {
            int s = Math.min(len, this.uncompressed.remaining());
            this.uncompressed.put(b, off, s);
            len -= s;
            off += s;
            if (this.uncompressed.remaining() != 0) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer();
            if (this.channel != null) {
                this.header.position(0);
                this.header.put(0);
                this.header.put(0);
                this.compressed.position(0);
                this.compressed.limit(8);
                this.channel.write(this.compressed);
            } else if (this.stream != null) {
                this.stream.write(new byte[8]);
            }
        }
        finally {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }

    private void flushBuffer() throws IOException {
        int uncompressedSize = this.uncompressed.position();
        this.uncompressed.position(0);
        int maxCompressedSize = this.compressBound(uncompressedSize) + 8;
        if (this.compressed == null || this.compressed.capacity() < maxCompressedSize) {
            this.compressed = this.allocateBuffer(maxCompressedSize);
            this.compressed.order(ByteOrder.LITTLE_ENDIAN);
            this.header = this.compressed.asIntBuffer();
            if (this.channel == null) {
                this.compressedArray = new byte[maxCompressedSize];
            }
        }
        int compressedSize = this.compress(this.uncompressed, 0, uncompressedSize, this.compressed, 8);
        this.header.position(0);
        this.header.put(compressedSize);
        this.header.put(uncompressedSize);
        this.compressed.position(0);
        this.compressed.limit(compressedSize + 8);
        if (this.channel != null) {
            this.channel.write(this.compressed);
        } else {
            this.compressed.get(this.compressedArray, 0, compressedSize + 8);
            this.stream.write(this.compressedArray, 0, compressedSize + 8);
        }
    }

    protected abstract int compressBound(int var1);

    protected abstract int compress(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5) throws IOException;

    protected abstract ByteBuffer allocateBuffer(int var1);
}

