/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.LZ4Java;
import org.simantics.fastlz.impl.Buffers;
import org.simantics.fastlz.impl.LZ4InputStream;
import org.simantics.fastlz.impl.LZ4OutputStream;
import org.simantics.fastlz.java.LZ4JavaInputStream;
import org.simantics.fastlz.java.LZ4JavaOutputStream;

public class LZ4 {
    private static boolean nativeInitialized = FastLZ.isNativeInitialized();

    static {
        FastLZ.isNativeInitialized();
    }

    public static int compressBound(int inputSize) {
        return inputSize + inputSize / 255 + 16;
    }

    static native int compress(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4);

    static native int decompress(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5);

    public static int compressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (LZ4.isNativeInitialized() && input.isDirect() && output.isDirect()) {
            return LZ4.compress(input, inputOffset, length, output, outputOffset);
        }
        byte[] inarr = Buffers.getInputArray(input);
        byte[] outarr = Buffers.getOutputArray(output);
        int result = LZ4Java.compress(inarr, inputOffset, length, outarr, outputOffset);
        Buffers.writeOutput(output, outarr);
        return result;
    }

    public static int decompressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset, int maxout) {
        if (output.isReadOnly()) {
            throw new IllegalArgumentException("read-only output buffer");
        }
        if (LZ4.isNativeInitialized() && input.isDirect() && output.isDirect()) {
            return LZ4.decompress(input, inputOffset, length, output, outputOffset, maxout);
        }
        byte[] inarr = Buffers.getInputArray(input);
        byte[] outarr = Buffers.getOutputArray(output);
        int result = LZ4Java.decompress(inarr, inputOffset, length, outarr, outputOffset, maxout);
        Buffers.writeOutput(output, outarr);
        return result;
    }

    public static InputStream read(File file) throws FileNotFoundException {
        return nativeInitialized ? new LZ4InputStream(file) : new LZ4JavaInputStream(file);
    }

    public static OutputStream write(File file) throws FileNotFoundException {
        return nativeInitialized ? new LZ4OutputStream(file) : new LZ4JavaOutputStream(file);
    }

    public static synchronized native int decompressCluster(ByteBuffer var0, int var1, int var2, Object[] var3);

    public static boolean isNativeInitialized() {
        return nativeInitialized;
    }
}

