/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.fastlz.ARCHType;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.OSType;
import org.simantics.fastlz.impl.OS;

public class FastLZTest1 {
    @Test
    public void testCalculateOS() {
        OSType os = OSType.calculate();
        Assert.assertTrue((String)"unknown OS type", (os != OSType.UNKNOWN ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateArch() {
        ARCHType arch = ARCHType.calculate();
        Assert.assertTrue((String)"unknown architecture type", (arch != ARCHType.UNKNOWN ? 1 : 0) != 0);
    }

    @Test
    public void testFormOsArchSuffix() {
        OS.formOsArchSuffix();
    }

    @Test
    public void testInitialize() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testCompress() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testDecompressCluster() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testDecompress() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testRead() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testWrite() {
        Assert.fail((String)"Not yet implemented");
    }

    public static void test() {
        byte[] data = new byte[537520000];
        while (true) {
            long beginTime;
            Closeable stream;
            try {
                int length;
                long beginTime2 = System.nanoTime();
                File snapfile = new File("d:/Loviisa080129/Loviisa080129.dir/loviisa080129.snp.gz");
                stream = new GZIPInputStream((InputStream)new FileInputStream(snapfile), 131072);
                int pos = 0;
                while ((length = ((GZIPInputStream)stream).read(data, pos, data.length - pos)) > 0) {
                    pos += length;
                }
                ((GZIPInputStream)stream).close();
                long endTime = System.nanoTime();
                System.out.println("Uncompressed size: " + pos);
                System.out.println("GZip read: " + (double)(endTime - beginTime2) * 1.0E-9 + "s");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                File file = new File("d:/testlz.dat");
                beginTime = System.nanoTime();
                OutputStream output = FastLZ.write(file);
                output.write(data);
                output.close();
                long endTime = System.nanoTime();
                System.out.println("FastLZ write: " + (double)(endTime - beginTime) * 1.0E-9 + "s");
                System.out.println("FastLZ compressed size: " + file.length());
                beginTime = System.nanoTime();
                InputStream input = FastLZ.read(file);
                input.read(data);
                input.close();
                endTime = System.nanoTime();
                System.out.println("FastLZ read: " + (double)(endTime - beginTime) * 1.0E-9 + "s");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                File snapfile = new File("d:/testgz.dat");
                beginTime = System.nanoTime();
                stream = new GZIPOutputStream(new FileOutputStream(snapfile));
                ((OutputStream)stream).write(data);
                ((OutputStream)stream).close();
                long endTime = System.nanoTime();
                System.out.println("GZip write: " + (double)(endTime - beginTime) * 1.0E-9 + "s");
                System.out.println("GZip compressed size: " + snapfile.length());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void test2() {
        File file = new File("d:/testi.flz");
        try {
            InputStream stream = FastLZ.read(file);
            byte[] b = new byte[100000];
            stream.read(b);
            int i = 0;
            while (i < 100000) {
                System.out.print((char)b[i]);
                ++i;
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

