/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.simantics.fastlz.ChecksumUtil;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.FastLZJava;
import org.simantics.fastlz.NullOutputStream;

public class FastLZBasicTests {
    static File testData1;
    static File testData2;
    static File testDataPrime;
    private static final int IO_BUFFER_SIZE = 131072;

    @BeforeClass
    public static void initialize() throws IOException {
        FastLZ.initialize(null);
        testData1 = new File("uncompressed.data");
        FastLZBasicTests.writeTestData(testData1, 10000000);
        testData2 = new File("uncompressed-small.data");
        FastLZBasicTests.writeTestData(testData2, 100000);
        testDataPrime = new File("uncompressed-prime.data");
        FastLZBasicTests.writeTestData(testDataPrime, 1000);
        System.out.println("test data directory: " + testData1.getAbsolutePath());
    }

    @Test
    public void validateCompress() throws IOException {
        this.validateCompress(testData1);
        this.validateCompress(new File("grades.snp"));
    }

    private void validateCompress(File testData) throws IOException {
        System.out.println("==== validateCompress(" + testData.getName() + ") ====");
        File nativeFlz = new File("compressed.data.native.flz");
        long nativeCompressedSize = FastLZBasicTests.compressFlzNative(testData, nativeFlz);
        System.out.println("native compressed size: " + nativeCompressedSize);
        File javaFlz = new File("compressed.data.java.flz");
        long javaCompressedSize = FastLZBasicTests.compressFlzJava(testData, javaFlz);
        System.out.println("java compressed size: " + javaCompressedSize);
        junit.framework.Assert.assertEquals((long)nativeCompressedSize, (long)javaCompressedSize);
        System.out.println("Comparing compressed outputs...");
        FastLZBasicTests.compareFiles(nativeFlz, javaFlz);
        System.out.println("Compressed outputs match.");
        File decompressedNativeFlz = new File("decompressed.data.native.flz");
        File decompressedJavaFlz = new File("decompressed.data.java.flz");
        FastLZBasicTests.decompressFlzNative(nativeFlz, decompressedNativeFlz);
        FastLZBasicTests.decompressFlzNative(javaFlz, decompressedJavaFlz);
        FastLZBasicTests.compareFiles(decompressedJavaFlz, decompressedNativeFlz);
        FastLZBasicTests.compareFiles(decompressedNativeFlz, testData);
    }

    @Test
    public void testDecompress() throws IOException {
        File nativeFlz = new File("compressed.data.native.flz");
        long nativeCompressedSize = FastLZBasicTests.compressFlzNative(testData1, nativeFlz);
        System.out.println("native compressed size: " + nativeCompressedSize);
        File javaFlz = new File("compressed.data.java.flz");
        long javaCompressedSize = FastLZBasicTests.compressFlzJava(testData1, javaFlz);
        System.out.println("java compressed size: " + javaCompressedSize);
        junit.framework.Assert.assertEquals((long)nativeCompressedSize, (long)javaCompressedSize);
        System.out.println("Comparing compressed outputs...");
        FastLZBasicTests.compareFiles(nativeFlz, javaFlz);
        System.out.println("Compressed outputs match.");
        File java1 = new File("java-compressed.data.decompressed-with-native");
        long nativeDecompressedSize = FastLZBasicTests.decompressFlzNative(javaFlz, java1);
        System.out.println("Comparing native-decompressed output...");
        FastLZBasicTests.compareFiles(testData1, java1);
        System.out.println("Native-decompressed output matches original.");
        File java2 = new File("java-compressed.data.decompressed-with-java");
        long javaDecompressedSize = FastLZBasicTests.decompressFlzJava(javaFlz, java2);
        System.out.println("Comparing java-decompressed output...");
        FastLZBasicTests.compareFiles(testData1, java2);
        System.out.println("Java-decompressed output matches original.");
        int i = 0;
        while (i < 5) {
            FastLZBasicTests.decompressFlz(javaFlz, FastLZ.read(javaFlz), java1, NullOutputStream.INSTANCE);
            ++i;
        }
        i = 0;
        while (i < 5) {
            FastLZBasicTests.decompressFlz(javaFlz, FastLZJava.read(javaFlz), java2, NullOutputStream.INSTANCE);
            ++i;
        }
    }

    @Test
    public void testDecompressCluster() {
        Assert.fail((String)"Not yet implemented");
    }

    static void compareFiles(File file1, File file2) throws IOException {
        BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(file1));
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
        try {
            int offset = 0;
            while (true) {
                int b1 = ((InputStream)in1).read();
                int b2 = ((InputStream)in2).read();
                if (b1 == -1 && b2 == -1) {
                    return;
                }
                if (b1 == -1) {
                    Assert.fail((String)("EOF reached in file1 " + file1.getName() + " but not in file2 " + file2.getName()));
                }
                if (b2 == -1) {
                    Assert.fail((String)("EOF reached in file1 " + file1.getName() + " but not in file2 " + file2.getName()));
                }
                if (b1 != b2) {
                    Assert.fail((String)("bytes at offset " + offset + " do not match: " + b1 + " vs. " + b2));
                }
                ++offset;
            }
        }
        finally {
            ((InputStream)in1).close();
            ((InputStream)in2).close();
        }
    }

    public static void writeTestData(File file, int rows) throws IOException {
        if (file.exists()) {
            return;
        }
        System.out.println("writing test data...");
        FileOutputStream stream = new FileOutputStream(file);
        int i = 0;
        while (i < rows) {
            ((OutputStream)stream).write((String.valueOf(Integer.toString(i)) + "\n").getBytes());
            ++i;
        }
        ((OutputStream)stream).close();
        System.out.println("wrote " + file.length() + " bytes of test data.");
    }

    static long compressFlzJava(File source, File flz) throws IOException {
        return FastLZBasicTests.compressFlz(source, flz, FastLZJava.write(flz));
    }

    static long compressFlzNative(File source, File flz) throws IOException {
        return FastLZBasicTests.compressFlz(source, flz, FastLZ.write(flz));
    }

    static long compressFlz(File source, File flz, OutputStream flzOutput) throws IOException {
        System.out.println("compressFlz(" + source + ", " + flz + ")");
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));
        FastLZBasicTests.copy(input, flzOutput);
        ((InputStream)input).close();
        flzOutput.close();
        long compressed = flz.length();
        System.out.println("Wrote " + compressed + " compressed bytes");
        return compressed;
    }

    static long decompressFlzJava(File flz, File dest) throws IOException {
        return FastLZBasicTests.decompressFlz(flz, FastLZJava.read(flz), dest);
    }

    static long decompressFlzNative(File flz, File dest) throws IOException {
        return FastLZBasicTests.decompressFlz(flz, FastLZ.read(flz), dest);
    }

    static long decompressFlz(File source, InputStream flzInput, File dest) throws IOException {
        System.out.println("decompressFlz(" + source + ", " + dest + ")");
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(dest));
        FastLZBasicTests.copy(flzInput, output);
        flzInput.close();
        ((OutputStream)output).close();
        long decompressed = dest.length();
        System.out.println("Wrote " + decompressed + " decompressed bytes");
        return decompressed;
    }

    static long decompressFlz(File source, InputStream flzInput, File dest, OutputStream destStream) throws IOException {
        System.out.println("decompressFlz(" + source + ", " + dest + ")");
        FastLZBasicTests.copy(flzInput, destStream);
        flzInput.close();
        destStream.close();
        long decompressed = dest.length();
        System.out.println("Wrote " + decompressed + " decompressed bytes");
        return decompressed;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] b = new byte[131072];
        long total = 0L;
        long start = System.nanoTime();
        while ((read = in.read(b)) >= 0) {
            total += (long)read;
            out.write(b, 0, read);
        }
        long end = System.nanoTime();
        double totalmb = (double)total / 1048576.0;
        double time = (double)(end - start) * 1.0E-9;
        double rate = totalmb / time;
        System.out.format("Transferred %d bytes (%.3f Mbytes) in %f seconds (%.3f MB/s)\n", total, totalmb, time, rate);
        return total;
    }

    private boolean checksumsEqual(File f1, File f2) throws IOException {
        byte[] s1 = ChecksumUtil.computeSum(f1);
        byte[] s2 = ChecksumUtil.computeSum(f2);
        return Arrays.equals(s1, s2);
    }
}

