/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.simantics.fastlz.CompressionCodec;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.LZ4;

public final class Compressions {
    public static final String FASTLZ = "FastLZ";
    public static final String LZ4 = "LZ4";

    public static CompressionCodec get(String codec) {
        if (FASTLZ.equals(codec)) {
            return new FastLZCodec();
        }
        if (LZ4.equals(codec)) {
            return new LZ4Codec();
        }
        throw new IllegalArgumentException("Unknown codec " + codec);
    }

    public static OutputStream write(String codec, File file) throws FileNotFoundException {
        return Compressions.get(codec).write(file);
    }

    public static InputStream read(String codec, File file) throws FileNotFoundException {
        return Compressions.get(codec).read(file);
    }

    private static class FastLZCodec
    implements CompressionCodec {
        private FastLZCodec() {
        }

        @Override
        public int compressBound(int inputSize) {
            return FastLZ.compressBound(inputSize);
        }

        @Override
        public int compressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset) {
            return FastLZ.compressBuffer(input, inputOffset, length, output, outputOffset);
        }

        @Override
        public int decompressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset, int maxout) {
            return FastLZ.decompressBuffer(input, inputOffset, length, output, outputOffset, maxout);
        }

        @Override
        public InputStream read(File file) throws FileNotFoundException {
            return FastLZ.read(file);
        }

        @Override
        public OutputStream write(File file) throws FileNotFoundException {
            return FastLZ.write(file);
        }
    }

    private static class LZ4Codec
    implements CompressionCodec {
        private LZ4Codec() {
        }

        @Override
        public int compressBound(int inputSize) {
            return org.simantics.fastlz.LZ4.compressBound(inputSize);
        }

        @Override
        public int compressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset) {
            return org.simantics.fastlz.LZ4.compressBuffer(input, inputOffset, length, output, outputOffset);
        }

        @Override
        public int decompressBuffer(ByteBuffer input, int inputOffset, int length, ByteBuffer output, int outputOffset, int maxout) {
            return org.simantics.fastlz.LZ4.decompressBuffer(input, inputOffset, length, output, outputOffset, maxout);
        }

        @Override
        public InputStream read(File file) throws FileNotFoundException {
            return org.simantics.fastlz.LZ4.read(file);
        }

        @Override
        public OutputStream write(File file) throws FileNotFoundException {
            return org.simantics.fastlz.LZ4.write(file);
        }
    }
}

