/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fastlz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ChecksumUtil {
    public static byte[] computeSum(byte[] in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(in, 0, in.length);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("MD5 digest must be supported by JVM");
        }
    }

    public static byte[] computeSum(InputStream in) throws IOException {
        MessageDigest md;
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("MD5 digest must be supported by JVM");
        }
        byte[] data = new byte[65536];
        int read;
        while ((read = in.read(data)) != -1) {
            md.update(data, 0, read);
        }
        return md.digest();
    }

    public static byte[] computeSum(File f) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            byte[] byArray = ChecksumUtil.computeSum(in);
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public static byte[] computeSum(URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            byte[] byArray = ChecksumUtil.computeSum(in);
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

