/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ChartPasteHandler
extends PasteHandlerAdapter {
    private Resource chart;

    public ChartPasteHandler(Resource chart) {
        this.chart = chart;
    }

    public void pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        final ArrayList resources = new ArrayList();
        for (Set object : clipboard.getContents()) {
            Collection rs = (Collection)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_COPY_RESOURCES);
            if (rs == null) continue;
            resources.addAll(rs);
        }
        if (resources.isEmpty()) {
            return;
        }
        graph.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource expectedModel = (Resource)graph.syncRequest((Read)new PossibleModel(ChartPasteHandler.this.chart));
                ArrayList<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>();
                for (Resource r : resources) {
                    Resource model;
                    if (!graph.isInstanceOf(r, MOD.Subscription_Item) || !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(r))))) continue;
                    refs.add(AddChartItem.createDescriptor((ReadGraph)graph, r));
                }
                if (!refs.isEmpty()) {
                    AddChartItem.addAndMoveChartItems(ChartPasteHandler.this.chart, refs, Collections.<Resource>emptySet()).perform(graph);
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter) {
            return this.chart;
        }
        return null;
    }
}

