/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartItemIcon;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.trend.impl.JarisPaints;
import org.simantics.utils.datastructures.ArrayMap;

public enum ChartItemImageRule implements ImageRule
{
    INSTANCE;

    public static final String[] COLUMN_KEYS;
    public static final String COLUMN_KEY = "single";
    ChartItemIcon chartIcons = new ChartItemIcon();

    static {
        COLUMN_KEYS = new String[]{COLUMN_KEY};
    }

    public static ChartItemImageRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource item = (Resource)content;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        Integer index = (Integer)graph.getPossibleRelatedValue(item, CHART.Chart_Item_Index);
        if (index == null) {
            index = 0;
        }
        Color color = JarisPaints.getColor((int)index);
        Resource rend = graph.getPossibleObject(item, CHART.Chart_Item_Renderer);
        boolean binary = CHART.Renderer_Binary.equals(rend);
        ImageDescriptor icon = this.chartIcons.createIcon(!binary, color, false);
        return ArrayMap.make((Object[])COLUMN_KEYS, (Object[])new ImageDescriptor[]{icon});
    }
}

