/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.List;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartItemDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source) throws DatabaseException {
        Resource chartItem = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (chartItem == null) {
            return null;
        }
        Resource targetModel = (Resource)g.syncRequest((Read)new PossibleModel(chartItem));
        List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource subscriptionItem = null;
        for (Resource res : srcs) {
            if (!g.isInstanceOf(res, MOD.Subscription_Item)) continue;
            if (subscriptionItem != null) {
                return null;
            }
            Resource model = (Resource)g.syncRequest((Read)new PossibleModel(res));
            if (!ObjectUtils.objectEquals((Object)targetModel, (Object)model)) continue;
            subscriptionItem = res;
        }
        if (subscriptionItem != null) {
            return this.setSubscriptionItem(chartItem, subscriptionItem);
        }
        return null;
    }

    private Runnable setSubscriptionItem(final Resource chartItem, final Resource subscriptionItem) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
                        graph.deny(chartItem, CHART.Chart_Item_HasSubscriptionItem);
                        graph.claim(chartItem, CHART.Chart_Item_HasSubscriptionItem, subscriptionItem);
                    }
                }, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }
        };
    }
}

