/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartGroupDropActionFactory;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.dialogs.ShowError;

public class ChartGroupPasteHandler
extends PasteHandlerAdapter {
    private Resource chartGroup;

    public ChartGroupPasteHandler(Resource chartGroup) {
        this.chartGroup = chartGroup;
    }

    public void pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        final ArrayList<Set> copied = new ArrayList<Set>();
        final ArrayList cut = new ArrayList();
        for (Set object : clipboard.getContents()) {
            Collection rs = (Collection)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_COPY_RESOURCES);
            if (rs != null) {
                copied.add(object);
                continue;
            }
            rs = (Collection)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_CUT_RESOURCES);
            if (rs == null) continue;
            cut.addAll(rs);
        }
        if (copied.isEmpty() && cut.isEmpty()) {
            return;
        }
        graph.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
                Resource expectedModel = (Resource)graph.syncRequest((Read)new PossibleModel(ChartGroupPasteHandler.this.chartGroup));
                if (!copied.isEmpty()) {
                    HashSet<Set<SimanticsClipboard.Representation>> sources = new HashSet<Set<SimanticsClipboard.Representation>>();
                    for (Set r : copied) {
                        Collection srcs = (Collection)ClipboardUtils.accept((Set)r, (IHintContext.Key)SimanticsKeys.KEY_COPY_RESOURCES);
                        for (Resource src : srcs) {
                            Resource model;
                            if (!graph.isInstanceOf(src, CHART.Chart) || !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(src))))) continue;
                            sources.add(r);
                        }
                    }
                    ChartGroupDropActionFactory.copyChartsRequest(ChartGroupPasteHandler.this.chartGroup, sources).perform(graph);
                } else if (!cut.isEmpty()) {
                    HashSet<Resource> sources = new HashSet<Resource>();
                    for (Resource r : cut) {
                        Resource model;
                        if (!graph.isInstanceOf(r, CHART.Chart) || !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(r))))) continue;
                        sources.add(r);
                    }
                    String error = ChartGroupDropActionFactory.validateDrop((ReadGraph)graph, ChartGroupPasteHandler.this.chartGroup, sources);
                    if (error != null) {
                        ShowError.showError((String)"Cut Failed", (String)error, null);
                        return;
                    }
                    ChartGroupDropActionFactory.moveChartsRequest(ChartGroupPasteHandler.this.chartGroup, sources).perform(graph);
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter) {
            return this.chartGroup;
        }
        return null;
    }
}

