/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class ChartGroupDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph graph, Object target, Object source) throws DatabaseException {
        Resource chartGroup = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (chartGroup == null) {
            return null;
        }
        Resource targetModel = (Resource)graph.syncRequest((Read)new PossibleModel(chartGroup));
        if (targetModel == null) {
            return null;
        }
        List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        HashSet<Resource> chartsToMove = new HashSet<Resource>();
        for (Resource res : srcs) {
            Resource partOf;
            Resource model;
            if (!graph.isInstanceOf(res, CHART.Chart) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(res)))) || ObjectUtils.objectEquals((Object)chartGroup, (Object)(partOf = graph.getPossibleObject(res, L0.PartOf)))) continue;
            chartsToMove.add(res);
        }
        if (!chartsToMove.isEmpty()) {
            String error = ChartGroupDropActionFactory.validateDrop(graph, chartGroup, chartsToMove);
            if (error != null) {
                ShowError.showError((String)"Chart Drop Failed", (String)error, null);
                return null;
            }
            return ChartGroupDropActionFactory.moveCharts(chartGroup, chartsToMove);
        }
        return null;
    }

    public static String validateDrop(ReadGraph graph, Resource chartGroup, Set<Resource> chartsToMove) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        String targetName = NameUtils.getSafeName((ReadGraph)graph, (Resource)chartGroup);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<String> sourceNames = new HashSet<String>();
        for (Resource chart : chartsToMove) {
            String chartName = NameUtils.getSafeName((ReadGraph)graph, (Resource)chart);
            if (sourceNames.add(chartName)) continue;
            sb.append("Multiple charts with same '" + chartName + "' cannot be moved into the same chart group.\n");
        }
        Set reservedNames = NameUtils.findReservedNames((ReadGraph)graph, (String)"", (Resource)chartGroup, (Resource)L0.ConsistsOf);
        for (String sourceName : sourceNames) {
            if (!reservedNames.contains(sourceName)) continue;
            sb.append("Name '" + sourceName + "' already in use in target '" + targetName + "'.\n");
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static Runnable moveCharts(final Resource chartGroup, final Set<Resource> chartsToMove) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)ChartGroupDropActionFactory.moveChartsRequest(chartGroup, chartsToMove), (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }
        };
    }

    public static MoveCharts moveChartsRequest(Resource chartGroup, Set<Resource> chartsToMove) {
        return new MoveCharts(chartGroup, chartsToMove);
    }

    public static CopyCharts copyChartsRequest(Resource chartGroup, Set<Set<SimanticsClipboard.Representation>> sources) {
        return new CopyCharts(chartGroup, sources);
    }

    public static class CopyCharts
    extends WriteRequest {
        private Resource chartGroup;
        private Set<Set<SimanticsClipboard.Representation>> sources;

        public CopyCharts(Resource chartGroup, Set<Set<SimanticsClipboard.Representation>> sources) {
            this.chartGroup = chartGroup;
            this.sources = sources;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            if (this.sources.isEmpty()) {
                return;
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            String targetName = NameUtils.getSafeName((ReadGraph)graph, (Resource)this.chartGroup);
            for (Set<SimanticsClipboard.Representation> r : this.sources) {
                Collection srcs = (Collection)ClipboardUtils.accept((ReadGraph)graph, r, (IHintContext.Key)SimanticsKeys.KEY_COPY_RESOURCES);
                for (Resource src : srcs) {
                    TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, r, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                    DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(this.chartGroup);
                    TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
                    cm.add("Copied chart '" + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)src) + "' to chart group '" + targetName + "'");
                }
            }
            graph.addMetadata((Metadata)cm);
        }
    }

    public static class MoveCharts
    extends WriteRequest {
        private Resource chartGroup;
        private Set<Resource> chartsToMove;

        public MoveCharts(Resource chartGroup, Set<Resource> chartsToMove) {
            this.chartGroup = chartGroup;
            this.chartsToMove = chartsToMove;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            if (this.chartsToMove.isEmpty()) {
                return;
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            String targetName = NameUtils.getSafeName((ReadGraph)graph, (Resource)this.chartGroup);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource chart : this.chartsToMove) {
                graph.deny(chart, L0.PartOf);
                graph.claim(this.chartGroup, L0.ConsistsOf, chart);
                cm.add("Moved chart '" + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)chart) + "' to chart group '" + targetName + "'");
            }
            graph.addMetadata((Metadata)cm);
        }
    }
}

