/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.ui.AddVariableToChartAction;
import org.simantics.charts.ui.ChartVariable;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source) throws DatabaseException {
        List wses;
        Resource chart = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (chart == null) {
            return null;
        }
        Resource targetModel = (Resource)g.syncRequest((Read)new PossibleModel(chart));
        if (targetModel == null) {
            return null;
        }
        if (source instanceof RVI) {
            RVI rvi = (RVI)source;
            List refs = CollectionUtils.toList((Object[])new VariableReference[]{new VariableReference(rvi, Variables.getDatatype((ReadGraph)g, (Resource)targetModel, (RVI)rvi), null)});
            AddVariableToChartAction a = new AddVariableToChartAction(chart, null, refs);
            a.init(g);
            return a;
        }
        List vars = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty()) {
            vars = PropertyVariablesImpl.resolve((ReadGraph)g, (List)vars);
            List references2 = (List)g.syncRequest(VariableReferences.toReferences((Resource)targetModel, (List)vars));
            ArrayList<VariableReference> references = new ArrayList<VariableReference>();
            for (VariableReference ref : references2) {
                if (!(ref.datatype instanceof BooleanType) && !(ref.datatype instanceof NumberType)) continue;
                references.add(ref);
            }
            AddVariableToChartAction a = new AddVariableToChartAction(chart, null, references);
            a.init(g);
            return a;
        }
        List vars2 = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Variable.class);
        if (!vars2.isEmpty()) {
            List references2 = (List)g.syncRequest(VariableReferences.variablesToReferences((Resource)targetModel, (List)vars2));
            ArrayList<VariableReference> references = new ArrayList<VariableReference>();
            for (VariableReference ref : references2) {
                if (!(ref.datatype instanceof BooleanType) && !(ref.datatype instanceof NumberType)) continue;
                references.add(ref);
            }
            AddVariableToChartAction a = new AddVariableToChartAction(chart, null, references);
            a.init(g);
            return a;
        }
        if (source instanceof ISelection && !(wses = ISelectionUtils.filterSelection((ISelection)((ISelection)source), WorkbenchSelectionElement.class)).isEmpty()) {
            ArrayList<Variable> wsevars = new ArrayList<Variable>();
            ChartVariable av = new ChartVariable((RequestProcessor)g);
            for (WorkbenchSelectionElement wse : wses) {
                Variable v = (Variable)wse.getContent((WorkbenchSelectionContentType)av);
                if (v == null) continue;
                wsevars.add(v);
            }
            if (!wsevars.isEmpty()) {
                List references2 = (List)g.syncRequest(VariableReferences.variablesToReferences((Resource)targetModel, wsevars));
                ArrayList<VariableReference> references = new ArrayList<VariableReference>();
                for (VariableReference ref : references2) {
                    if (!(ref.datatype instanceof BooleanType) && !(ref.datatype instanceof NumberType)) continue;
                    references.add(ref);
                }
                AddVariableToChartAction a = new AddVariableToChartAction(chart, null, references);
                a.init(g);
                return a;
            }
        }
        List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        ArrayList<ChartItemDescriptor> newItems = new ArrayList<ChartItemDescriptor>();
        HashSet<Resource> movedPlots = new HashSet<Resource>();
        for (Resource res : srcs) {
            Resource model;
            if (g.isInstanceOf(res, MOD.Subscription_Item)) {
                model = (Resource)g.syncRequest((Read)new PossibleModel(res));
                if (!ObjectUtils.objectEquals((Object)targetModel, (Object)model)) continue;
                ChartItemDescriptor desc = new ChartItemDescriptor();
                desc.subscriptionItem = res;
                Datatype datatype = (Datatype)g.getPossibleRelatedValue(res, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
                desc.renderer = datatype instanceof BooleanType ? TrendItem.Renderer.Binary : TrendItem.Renderer.Analog;
                newItems.add(desc);
                continue;
            }
            if (!g.isInstanceOf(res, CHART.Chart_Item) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)g.syncRequest((Read)new PossibleModel(res))))) continue;
            movedPlots.add(res);
        }
        if (!newItems.isEmpty() || !movedPlots.isEmpty()) {
            return ChartDropActionFactory.addPlots(chart, newItems, movedPlots);
        }
        return null;
    }

    public static Runnable addPlots(final Resource chart, final List<ChartItemDescriptor> references, final Set<Resource> movedPlots) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)AddChartItem.addAndMoveChartItems(chart, references, movedPlots), (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }
        };
    }
}

