/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.swt.widgets.Display;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.charts.query.ChartAndSubscriptionItemReadQuery;
import org.simantics.charts.query.ChartAndSubscriptionItemWriteAction;
import org.simantics.charts.query.ChartDataQuery;
import org.simantics.charts.query.ChartDataWrite;
import org.simantics.charts.ui.ChartAndSubscriptionItemDialog;
import org.simantics.charts.ui.ChartData;
import org.simantics.charts.ui.ChartDialog;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class ChartDoubleClickHandler
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        Resource resource = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (resource == null) {
            return;
        }
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(resource, CHART.Chart_Item)) {
            Display display = Display.getDefault();
            ChartDoubleClickHandler.openChartItemPropertiesDialog(g, resource, display);
            e.consume();
        }
    }

    public static void openChartItemPropertiesDialog(ReadGraph g, final Resource chartItem, Display display) throws DatabaseException {
        ChartAndSubscriptionItemReadQuery query = new ChartAndSubscriptionItemReadQuery(chartItem);
        final ChartAndSubscriptionItemData data = (ChartAndSubscriptionItemData)((Object)g.sync((ReadInterface)query));
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                ChartAndSubscriptionItemDialog d = new ChartAndSubscriptionItemDialog(display.getActiveShell(), data, true);
                if (d.open() != 0) {
                    return;
                }
                try {
                    SimanticsUI.getSession().sync((WriteInterface)new ChartAndSubscriptionItemWriteAction(chartItem, d.data));
                }
                catch (DatabaseException e) {
                    ShowError.showError((String)((Object)((Object)e)).getClass().getName(), (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }

    public static void openChartPropertiesDialog(ReadGraph g, final Resource chart, Display display) throws DatabaseException {
        ChartDataQuery query = new ChartDataQuery(chart);
        final ChartData data = (ChartData)((Object)g.sync((ReadInterface)query));
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                ChartDialog d = new ChartDialog(display.getActiveShell(), data);
                if (d.open() != 0) {
                    return;
                }
                try {
                    SimanticsUI.getSession().sync((WriteInterface)new ChartDataWrite(chart, d.data));
                }
                catch (DatabaseException e) {
                    ShowError.showError((String)((Object)((Object)e)).getClass().getName(), (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }
}

