/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.ui.ChartData;
import org.simantics.modeling.ui.chart.property.ChartComposite;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.utils.format.TimeFormat;

public class ChartDialog
extends Dialog {
    Label lName;
    Label lStartTime;
    Label lLength;
    Label lScrollIncrement;
    Label lAxisMode;
    Text tName;
    Text tStartTime;
    Text tLength;
    Scale sIncrement;
    Combo cAxisMode;
    Button bMilestones;
    ChartData data;

    public ChartDialog(Shell parentShell, ChartData data) {
        super(parentShell);
        this.data = data;
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        String str;
        TimeFormat timeFormat;
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().grab(true, false).span(8, 1);
        this.lName = new Label(c, 0);
        this.lName.setText("Name:");
        gd1.applyTo((Control)this.lName);
        this.tName = new Text(c, 2048);
        this.tName.setEnabled(true);
        if (this.data.name != null) {
            this.tName.setText(this.data.name);
        }
        gd2.applyTo((Control)this.tName);
        Label l = new Label(c, 0);
        l.setText("Chart Time Window Preference (Auto-scale)");
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)l);
        this.lStartTime = new Label(c, 0);
        this.lStartTime.setText("Time Start:");
        gd1.applyTo((Control)this.lStartTime);
        this.tStartTime = new Text(c, 2048);
        if (this.data.timeStart != null) {
            timeFormat = new TimeFormat(100.0, 3);
            str = timeFormat.format(this.data.timeStart);
            this.tStartTime.setText(str);
        }
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.tStartTime);
        this.lLength = new Label(c, 0);
        this.lLength.setText("Length:");
        gd1.applyTo((Control)this.lLength);
        this.tLength = new Text(c, 2048);
        if (this.data.timeLength != null) {
            timeFormat = new TimeFormat(100.0, 3);
            str = timeFormat.format(this.data.timeLength);
            this.tLength.setText(str);
        }
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.tLength);
        this.lScrollIncrement = new Label(c, 0);
        this.lScrollIncrement.setText("Scroll Increment:");
        gd1.applyTo((Control)this.lScrollIncrement);
        this.sIncrement = new Scale(c, 256);
        this.sIncrement.setMinimum(1);
        this.sIncrement.setMaximum(100);
        this.sIncrement.setIncrement(10);
        this.sIncrement.setPageIncrement(10);
        if (this.data.timeIncrement != null) {
            this.sIncrement.setSelection((int)this.data.timeIncrement.doubleValue());
        }
        gd2.applyTo((Control)this.sIncrement);
        this.lAxisMode = new Label(c, 0);
        this.lAxisMode.setText("AxisMode:");
        gd1.applyTo((Control)this.lAxisMode);
        this.cAxisMode = new Combo(c, 2060);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.cAxisMode);
        this.cAxisMode.add("Single");
        this.cAxisMode.add("Multi");
        String _mode = this.data.axisMode == YAxisMode.SingleAxis ? "Single" : "Multi";
        this.cAxisMode.setText(_mode);
        this.bMilestones = new Button(c, 32);
        this.bMilestones.setText("Show Milestones");
        this.bMilestones.setSelection(this.data.showMilestones);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.bMilestones);
        return c;
    }

    protected void okPressed() {
        this.data.name = this.tName.getText();
        this.data.showMilestones = this.bMilestones.getSelection();
        this.data.axisMode = this.cAxisMode.getSelectionIndex() == 0 ? YAxisMode.SingleAxis : YAxisMode.MultiAxis;
        this.data.timeIncrement = this.sIncrement.getSelection();
        this.data.timeLength = ChartComposite.LENGTH_VALIDATOR.parse(this.tLength.getText());
        this.data.timeStart = ChartComposite.START_VALIDATOR.parse(this.tStartTime.getText());
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit chart");
    }
}

