/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;

public class ChartAndSubscriptionItemDialog
extends Dialog {
    Label lChart;
    Label lRVI;
    Label lLabel;
    Label lDrawMode;
    Label lScale;
    Label lMin;
    Label lMax;
    Label lSubscription;
    Label lDeadband;
    Label lInterval;
    Label lGain;
    Label lBias;
    Label lUnit;
    Text tRVI;
    Text tLabel;
    Text tDeadband;
    Text tInterval;
    Text tGain;
    Text tBias;
    Text tUnit;
    Combo cSubscription;
    Button saveAsPrefs;
    Text tChart;
    Text tMin;
    Text tMax;
    Combo cDrawMode;
    Combo cScale;
    ChartAndSubscriptionItemData data;
    IEclipsePreferences chartnode;
    IEclipsePreferences subscriptionnode;
    boolean includeChartSpecificProperties;

    public ChartAndSubscriptionItemDialog(Shell parentShell, ChartAndSubscriptionItemData data, boolean includeChartSpecificProperties) {
        super(parentShell);
        this.data = data;
        this.includeChartSpecificProperties = includeChartSpecificProperties;
        if (includeChartSpecificProperties) {
            this.chartnode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        }
        this.subscriptionnode = InstanceScope.INSTANCE.getNode("org.simantics.modeling");
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().grab(true, false).span(8, 1);
        if (this.includeChartSpecificProperties) {
            this.lChart = new Label(c, 0);
            this.lChart.setText("Chart:");
            gd1.applyTo((Control)this.lChart);
            this.tChart = new Text(c, 2048);
            this.tChart.setEnabled(false);
            if (this.data.chartName != null) {
                this.tChart.setText(this.data.chartName);
            }
            gd2.applyTo((Control)this.tChart);
        }
        this.lRVI = new Label(c, 0);
        this.lRVI.setText("Variable: ");
        gd1.applyTo((Control)this.lRVI);
        this.tRVI = new Text(c, 2048);
        this.tRVI.setEnabled(false);
        if (this.data.variableReference != null) {
            this.tRVI.setText(URIStringUtils.unescape((String)this.data.variableReference));
        }
        gd2.applyTo((Control)this.tRVI);
        this.lLabel = new Label(c, 0);
        this.lLabel.setText("&Label: ");
        gd1.applyTo((Control)this.lLabel);
        this.tLabel = new Text(c, 2048);
        if (this.data.label != null) {
            this.tLabel.setText(this.data.label);
        }
        gd2.applyTo((Control)this.tLabel);
        if (!this.data.binaryMode && this.includeChartSpecificProperties) {
            this.lScale = new Label(c, 0);
            this.lScale.setText("&Scale: ");
            gd1.applyTo((Control)this.lScale);
            Composite scaleComposite = new Composite(c, 0);
            gd2.applyTo((Control)scaleComposite);
            GridLayoutFactory.fillDefaults().numColumns(8).applyTo(scaleComposite);
            this.cScale = new Combo(scaleComposite, 2060);
            this.cScale.add("Auto");
            this.cScale.add("Manual");
            String _scale = this.data.scale != null ? this.data.scale.toString() : this.chartnode.get("chart.scalemode", "Auto");
            this.cScale.setText(_scale);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.cScale);
            this.lMin = new Label(scaleComposite, 0);
            this.lMin.setText("&Min: ");
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.lMin);
            this.tMin = new Text(scaleComposite, 2048);
            Double _min = this.data.min;
            if (_min == null) {
                _min = this.chartnode.getDouble("chart.scale.min", 0.0);
            }
            this.tMin.setText(Double.toString(_min));
            GridDataFactory.fillDefaults().hint(80, -1).grab(true, false).span(2, 1).applyTo((Control)this.tMin);
            this.lMax = new Label(scaleComposite, 0);
            this.lMax.setText("Ma&x: ");
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.lMax);
            this.tMax = new Text(scaleComposite, 2048);
            Double _max = this.data.max;
            if (_max == null) {
                _max = this.chartnode.getDouble("chart.scale.max", 100.0);
            }
            this.tMax.setText(Double.toString(_max));
            GridDataFactory.fillDefaults().hint(80, -1).grab(true, false).span(2, 1).applyTo((Control)this.tMax);
        }
        this.lSubscription = new Label(c, 0);
        this.lSubscription.setText("S&ubscription: ");
        gd1.applyTo((Control)this.lSubscription);
        this.cSubscription = new Combo(c, 2048);
        String[] stringArray = this.data.subscriptions;
        int _min = this.data.subscriptions.length;
        int _scale = 0;
        while (_scale < _min) {
            String s = stringArray[_scale];
            this.cSubscription.add(s);
            ++_scale;
        }
        gd2.applyTo((Control)this.cSubscription);
        String _subscription = this.data.subscription;
        if (_subscription == null) {
            _subscription = this.subscriptionnode.get("subscriptionitem.subscription", this.data.subscriptions.length == 0 ? "Default" : this.cSubscription.getItem(0));
        }
        this.cSubscription.setText(_subscription);
        if (!this.data.binaryMode) {
            this.lDeadband = new Label(c, 0);
            this.lDeadband.setText("&Deadband: ");
            gd1.applyTo((Control)this.lDeadband);
            this.tDeadband = new Text(c, 2048);
            Double _deadband = this.data.deadband;
            if (_deadband == null) {
                _deadband = this.subscriptionnode.getDouble("subscriptionitem.deadband", 0.0);
            }
            this.tDeadband.setText(Double.toString(_deadband));
            this.tDeadband.setEditable(this.data.mutableCollectionSettings);
            GridDataFactory.fillDefaults().hint(110, -1).span(3, 1).applyTo((Control)this.tDeadband);
            this.lInterval = new Label(c, 0);
            this.lInterval.setText("&Interval: ");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lInterval);
            this.tInterval = new Text(c, 2048);
            Double _interval = this.data.interval;
            if (_interval == null) {
                _interval = this.subscriptionnode.getDouble("subscriptionitem.interval", 0.0);
            }
            this.tInterval.setText(Double.toString(_interval));
            this.tInterval.setEditable(this.data.mutableCollectionSettings);
            GridDataFactory.fillDefaults().hint(110, -1).span(3, 1).applyTo((Control)this.tInterval);
        }
        if (!this.data.binaryMode) {
            this.lGain = new Label(c, 0);
            this.lGain.setText("&Gain: ");
            gd1.applyTo((Control)this.lGain);
            this.tGain = new Text(c, 2048);
            Double _gain = this.data.gain;
            if (_gain == null) {
                _gain = this.subscriptionnode.getDouble("subscriptionitem.gain", 1.0);
            }
            this.tGain.setText(Double.toString(_gain));
            GridDataFactory.fillDefaults().hint(110, -1).span(3, 1).applyTo((Control)this.tGain);
            this.lBias = new Label(c, 0);
            this.lBias.setText("&Bias: ");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lBias);
            this.tBias = new Text(c, 2048);
            Double _bias = this.data.bias;
            if (_bias == null) {
                _bias = this.subscriptionnode.getDouble("subscriptionitem.bias", 0.0);
            }
            this.tBias.setText(Double.toString(_bias));
            GridDataFactory.fillDefaults().hint(110, -1).span(3, 1).applyTo((Control)this.tBias);
        }
        if (!this.data.binaryMode) {
            this.lUnit = new Label(c, 0);
            this.lUnit.setText("U&nit: ");
            gd1.applyTo((Control)this.lUnit);
            this.tUnit = new Text(c, 2048);
            String _unit = this.data.unit;
            if (_unit == null) {
                _unit = this.subscriptionnode.get("subscriptionitem.unit", "");
            }
            this.tUnit.setText(_unit);
            this.tUnit.setEditable(this.data.mutableCollectionSettings);
            GridDataFactory.fillDefaults().hint(100, -1).span(3, 1).applyTo((Control)this.tUnit);
        }
        if (!this.data.hasSubscriptionItem) {
            this.tLabel.setEnabled(false);
            this.cSubscription.setEnabled(false);
            this.tDeadband.setEnabled(false);
            this.tInterval.setEnabled(false);
            this.tGain.setEnabled(false);
            this.tBias.setEnabled(false);
            this.tUnit.setEnabled(false);
        }
        this.saveAsPrefs = new Button(c, 32);
        this.saveAsPrefs.setText("Sav&e as new defaults");
        this.saveAsPrefs.setToolTipText("Sav&e these settings as new defaults");
        this.saveAsPrefs.setSelection(false);
        GridDataFactory.fillDefaults().hint(100, -1).span(9, 1).applyTo((Control)this.saveAsPrefs);
        return c;
    }

    protected void okPressed() {
        boolean savePrefs = this.saveAsPrefs.getSelection();
        this.data.label = this.tLabel.getText();
        if (!this.data.binaryMode) {
            String str;
            if (this.includeChartSpecificProperties) {
                try {
                    str = this.tMin.getText();
                    this.data.min = str == null ? null : Double.valueOf(str);
                }
                catch (NumberFormatException nfe) {
                    this.data.min = 0.0;
                }
                try {
                    str = this.tMax.getText();
                    this.data.max = str == null ? null : Double.valueOf(str);
                }
                catch (NumberFormatException nfe) {
                    this.data.max = 100.0;
                }
            }
            try {
                str = this.tInterval.getText();
                this.data.interval = str == null ? null : Double.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                this.data.interval = 0.0;
            }
            try {
                str = this.tDeadband.getText();
                this.data.deadband = str == null ? null : Double.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                this.data.deadband = 0.0;
            }
            try {
                str = this.tGain.getText();
                this.data.gain = str == null ? null : Double.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                this.data.gain = 1.0;
            }
            try {
                str = this.tBias.getText();
                this.data.bias = str == null ? null : Double.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                this.data.bias = 0.0;
            }
            this.data.unit = this.tUnit.getText();
            if (this.includeChartSpecificProperties) {
                this.data.drawmode = TrendItem.DrawMode.Line;
                if (this.cScale.getText().equals("Manual")) {
                    this.data.scale = new Scale.Manual(this.data.min.doubleValue(), this.data.max.doubleValue());
                } else if (this.cScale.getText().equals("Auto")) {
                    this.data.scale = new Scale.Auto();
                }
            }
            if (savePrefs) {
                if (this.includeChartSpecificProperties) {
                    this.chartnode.put("chart.drawmode", this.data.drawmode.name());
                    this.chartnode.put("chart.scalemode", this.data.scale instanceof Scale.Manual ? "Manual" : "Auto");
                    this.chartnode.putDouble("chart.scale.min", this.data.min.doubleValue());
                    this.chartnode.putDouble("chart.scale.max", this.data.max.doubleValue());
                }
                this.subscriptionnode.putDouble("subscriptionitem.deadband", this.data.deadband.doubleValue());
                this.subscriptionnode.putDouble("subscriptionitem.interval", this.data.interval.doubleValue());
                this.subscriptionnode.putDouble("subscriptionitem.gain", this.data.gain.doubleValue());
                this.subscriptionnode.putDouble("subscriptionitem.bias", this.data.bias.doubleValue());
                this.subscriptionnode.put("subscriptionitem.unit", this.data.unit);
            }
        }
        this.data.subscription = this.cSubscription.getText();
        if (savePrefs) {
            this.subscriptionnode.put("subscriptionitem.subscription", this.data.subscription);
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.includeChartSpecificProperties ? "Edit variable to chart and subscription item" : "Edit variable to subscription item");
    }
}

