/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.editor.ChartData;
import org.simantics.charts.editor.ChartKeys;
import org.simantics.charts.ui.CSVExportPlan;
import org.simantics.charts.ui.CSVParamsQuery;
import org.simantics.charts.ui.CSVProgressMonitor;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.history.HistoryException;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class CSVExporter
implements IRunnableWithProgress {
    CSVExportPlan exportModel;

    public CSVExporter(CSVExportPlan exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        try {
            try {
                this.exportModel(progress.newChild(50, 0));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                throw new InvocationTargetException(e);
            }
            catch (BindingException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException, SerializationException, BindingException {
        try {
            try {
                CSVExporter.doExport((IProgressMonitor)mon, this.exportModel.exportLocation, this.exportModel);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Logger.defaultLogError((Throwable)e);
                mon.setCanceled(true);
                ShowMessage.showError((String)"Export failed.", (String)"Internal application error in export. See log for details.");
                mon.setWorkRemaining(0);
            }
        }
        finally {
            mon.setWorkRemaining(0);
        }
    }

    private static Set<Resource> resolveContainingModels(final Collection<NamedResource> res) throws DatabaseException {
        return (Set)Simantics.getSession().syncRequest((Read)new UniqueRead<Set<Resource>>(){

            public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> models = new HashSet<Resource>();
                for (NamedResource r : res) {
                    Resource m = (Resource)graph.syncRequest((Read)new PossibleModel(r.getResource()));
                    if (m == null) continue;
                    models.add(m);
                }
                return models;
            }
        });
    }

    public static void doExport(IProgressMonitor monitor, File f, CSVExportPlan plan) throws ExecutionException, IOException {
        Set<Resource> models;
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.simantics.modeling");
        node.putDouble("csv.start", plan.startTime);
        node.putDouble("csv.step", plan.timeStep);
        node.put("csv.decimal.separator", plan.decimalSeparator.toPreference());
        node.put("csv.value.separator", plan.columnSeparator.toPreference());
        node.putBoolean("csv.resample", plan.resample);
        node.put("csv.sampling.mode", plan.samplingMode.toPreference());
        node.putInt("csv.format.time.digits", plan.timeDigits);
        node.putInt("csv.format.float.digits", plan.floatDigits);
        node.putInt("csv.format.double.digits", plan.doubleDigits);
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.charts", "Could not store preferences for node " + node.absolutePath()));
        }
        try {
            models = CSVExporter.resolveContainingModels(plan.models);
        }
        catch (DatabaseException e3) {
            throw new ExecutionException("Containing model resolution failed.", (Throwable)e3);
        }
        if (models.isEmpty()) {
            throw new ExecutionException("Selected resources are not part of any model");
        }
        if (models.size() > 1) {
            throw new ExecutionException("Selected resources are part of several models, only subscriptions from a single model can be selected");
        }
        Resource model = models.iterator().next();
        ChartKeys.ChartSourceKey chartDataKey = ChartKeys.chartSourceKey(model);
        ChartData data = (ChartData)Simantics.getProject().getHint((IHintContext.Key)chartDataKey);
        if (data == null) {
            throw new ExecutionException("There is no " + (Object)((Object)chartDataKey));
        }
        if (data.history == null) {
            throw new ExecutionException("There is no history in " + (Object)((Object)chartDataKey));
        }
        CSVFormatter csv = new CSVFormatter();
        csv.setStartTime(plan.startTime);
        csv.setTimeStep(plan.timeStep);
        csv.setDecimalSeparator(plan.decimalSeparator);
        csv.setColumnSeparator(plan.columnSeparator);
        csv.setResample(plan.resample);
        csv.setNumberInterpolation(plan.samplingMode);
        csv.setTimeFormat(FormattingUtils.significantDigitFormat((int)plan.timeDigits));
        csv.setFloatFormat(FormattingUtils.significantDigitFormat((int)plan.floatDigits));
        csv.setNumberFormat(FormattingUtils.significantDigitFormat((int)plan.doubleDigits));
        try {
            Session session = Simantics.getSession();
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (NamedResource nr : plan.models) {
                list.add(nr.getResource());
            }
            session.sync((ReadInterface)new CSVParamsQuery(data.history, csv, list));
            csv.sort();
        }
        catch (DatabaseException e2) {
            throw new ExecutionException(e2.getMessage(), (Throwable)e2);
        }
        catch (HistoryException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        try {
            monitor.beginTask("Exporting Time Series as CSV...", -1);
            try {
                data.collector.flush();
                if (!f.exists()) {
                    f.createNewFile();
                } else {
                    RandomAccessFile raf = new RandomAccessFile(f, "rw");
                    raf.setLength(0L);
                    raf.close();
                }
                FileOutputStream fos = new FileOutputStream(f, true);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                try {
                    PrintStream ps = new PrintStream(bos);
                    csv.formulate2((ProgressMonitor)new CSVProgressMonitor(monitor), (Appendable)ps);
                    bos.flush();
                }
                finally {
                    fos.close();
                }
            }
            catch (HistoryException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e1) {
                throw new ExecutionException(e1.getMessage(), (Throwable)e1);
            }
            monitor.setTaskName("Done");
        }
        finally {
            monitor.done();
        }
    }
}

