/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.trend.configuration.YAxisMode;

public class ChartDataQuery
extends ResourceRead<ChartData> {
    public ChartDataQuery(Resource resource) {
        super(resource);
    }

    public ChartData perform(ReadGraph g) throws DatabaseException {
        Boolean showMilestones;
        Double start;
        Double length;
        Resource chart = this.resource;
        ChartData data = new ChartData();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        data.name = (String)g.getPossibleRelatedValue(chart, L0.HasName, (Binding)Bindings.STRING);
        Resource am = g.getSingleObject(chart, CHART.Chart_YAxisMode);
        data.axisMode = CHART.YAxisMode_SingleAxis.equals(am) ? YAxisMode.SingleAxis : (CHART.YAxisMode_MultiAxis.equals(am) ? YAxisMode.MultiAxis : YAxisMode.SingleAxis);
        Double increment = (Double)g.getPossibleRelatedValue(chart, CHART.Chart_TimeWindowIncrement, (Binding)Bindings.DOUBLE);
        if (increment != null) {
            data.timeIncrement = increment;
        }
        if ((length = (Double)g.getPossibleRelatedValue(chart, CHART.Chart_TimeWindowLength, (Binding)Bindings.DOUBLE)) != null) {
            data.timeLength = length;
        }
        if ((start = (Double)g.getPossibleRelatedValue(chart, CHART.Chart_TimeWindowStart, (Binding)Bindings.DOUBLE)) != null) {
            data.timeStart = start;
        }
        if ((showMilestones = (Boolean)g.getPossibleRelatedValue(chart, CHART.Chart_ShowMilestones, (Binding)Bindings.BOOLEAN)) != null) {
            data.showMilestones = showMilestones;
        }
        return data;
    }
}

