/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import org.simantics.charts.editor.TrendItemQuery;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionsQuery;
import org.simantics.trend.configuration.TrendItem;

public class ChartAndSubscriptionItemReadQuery
extends ResourceRead<ChartAndSubscriptionItemData> {
    public ChartAndSubscriptionItemReadQuery(Resource chartItem) {
        super(chartItem);
    }

    public ChartAndSubscriptionItemData perform(ReadGraph g) throws DatabaseException {
        ChartAndSubscriptionItemData data = new ChartAndSubscriptionItemData();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        Resource chartItem = this.resource;
        Resource chart = g.getPossibleObject(chartItem, L0.PartOf);
        Resource model = (Resource)g.syncRequest((Read)new PossibleModel(chart));
        Resource subscriptionItem = g.getPossibleObject(chartItem, CHART.Chart_Item_HasSubscriptionItem);
        Resource subscription = subscriptionItem == null ? null : g.getPossibleObject(subscriptionItem, L0.PartOf);
        SubscriptionsQuery.SubscriptionsResult subscriptions = (SubscriptionsQuery.SubscriptionsResult)g.sync((ReadInterface)new SubscriptionsQuery(model));
        TrendItem trendItem = (TrendItem)g.sync((ReadInterface)new TrendItemQuery(chartItem));
        if (subscriptionItem != null) {
            Variable configuration = Variables.getConfigurationContext((ReadGraph)g, (Resource)subscription);
            Binding rviBinding = ((Databoard)g.getService(Databoard.class)).getBindingUnchecked(RVI.class);
            RVI rvi = (RVI)g.getRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding);
            data.variableReference = rvi.toPossibleString(g, configuration);
        }
        data.chartName = (String)g.getPossibleRelatedValue(chart, L0.HasName, (Binding)Bindings.STRING);
        data.subscriptions = subscriptions.toNames();
        data.subscriptions = subscriptions.names.toArray(new String[subscriptions.names.size()]);
        data.drawmode = trendItem.drawMode;
        data.binaryMode = trendItem.renderer == TrendItem.Renderer.Binary;
        data.subscription = subscriptions.getName(subscription);
        data.scale = trendItem.scale;
        if (data.subscription == null) {
            data.subscription = "";
        }
        data.min = (Double)g.getPossibleRelatedValue(chartItem, CHART.Chart_Item_ScaleMode_Min, (Binding)Bindings.DOUBLE);
        data.max = (Double)g.getPossibleRelatedValue(chartItem, CHART.Chart_Item_ScaleMode_Max, (Binding)Bindings.DOUBLE);
        boolean bl = data.hasSubscriptionItem = subscriptionItem != null;
        if (data.hasSubscriptionItem) {
            data.label = (String)g.getPossibleRelatedValue(subscriptionItem, L0.HasLabel, (Binding)Bindings.STRING);
            data.bias = (Double)g.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Bias, (Binding)Bindings.DOUBLE);
            data.gain = (Double)g.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Gain, (Binding)Bindings.DOUBLE);
            data.deadband = (Double)g.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Deadband, (Binding)Bindings.DOUBLE);
            data.interval = (Double)g.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_SamplingInterval, (Binding)Bindings.DOUBLE);
            data.unit = (String)g.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
        } else {
            data.variableReference = trendItem.label;
        }
        return data;
    }
}

