/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.util.Collection;
import java.util.UUID;
import org.simantics.charts.editor.TrendItemQuery;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.configuration.ViewProfile;
import org.simantics.trend.configuration.YAxisMode;

public class TrendSpecQuery
extends BinaryRead<UUID, Resource, TrendSpec> {
    public TrendSpecQuery(UUID id, Resource resource) {
        super((Object)id, (Object)resource);
    }

    public TrendSpec perform(ReadGraph graph) throws DatabaseException {
        Resource chart = (Resource)this.parameter2;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TrendSpec spec = new TrendSpec();
        spec.init();
        if (!graph.hasStatement(chart)) {
            return spec;
        }
        spec.name = (String)graph.getPossibleRelatedValue(chart, L0.HasName, (Binding)Bindings.STRING);
        if (spec.name == null) {
            spec.name = "Unnamed Chart";
        }
        spec.axisMode = YAxisMode.MultiAxis;
        Resource axisMode = graph.getPossibleObject(chart, CHART.Chart_YAxisMode);
        if (CHART.YAxisMode_SingleAxis.equals(axisMode)) {
            spec.axisMode = YAxisMode.SingleAxis;
        } else if (CHART.YAxisMode_MultiAxis.equals(axisMode)) {
            spec.axisMode = YAxisMode.MultiAxis;
        }
        this.readProfile(graph, chart, spec.viewProfile);
        for (Resource plot : (Collection)graph.syncRequest((Read)new ObjectsWithType(chart, L0.ConsistsOf, CHART.Chart_Item))) {
            TrendItem item = (TrendItem)graph.sync((ReadInterface)new TrendItemQuery(plot));
            spec.items.add(item);
        }
        spec.sortItems();
        return spec;
    }

    private void readProfile(ReadGraph graph, Resource profile, ViewProfile viewProfile) throws DatabaseException {
        viewProfile.profileName = "Custom Profile";
        viewProfile.showMilestones = false;
        viewProfile.timeWindow.timeWindowIncrement = 50.0;
        if (profile != null) {
            Double windowIncrement;
            Double windowLength;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
            String pn = (String)graph.getPossibleRelatedValue(profile, L0.HasName);
            if (pn != null) {
                viewProfile.profileName = pn;
            }
            Boolean sm = (Boolean)graph.getPossibleRelatedValue(profile, CHART.Chart_ShowMilestones);
            viewProfile.showMilestones = Boolean.TRUE.equals(sm);
            Double windowStart = (Double)graph.getPossibleRelatedAdapter(profile, CHART.Chart_TimeWindowStart, Double.class);
            if (windowStart != null && !Double.isNaN(windowStart)) {
                viewProfile.timeWindow.timeWindowStart = windowStart;
            }
            if ((windowLength = (Double)graph.getPossibleRelatedAdapter(profile, CHART.Chart_TimeWindowLength, Double.class)) != null) {
                viewProfile.timeWindow.timeWindowLength = windowLength;
            }
            if ((windowIncrement = (Double)graph.getPossibleRelatedAdapter(profile, CHART.Chart_TimeWindowIncrement, Double.class)) != null) {
                viewProfile.timeWindow.timeWindowIncrement = windowIncrement;
            }
        }
    }
}

