/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.utils.format.TimeFormat;

public class TimeInputValidator
implements IInputValidator {
    public static final TimeInputValidator INSTANCE = new TimeInputValidator();
    public Format decimalFormat = new DecimalFormat("0");
    public Format timeFormat = new TimeFormat(100.0, 0);

    public Double parse(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).equals("")) {
            return null;
        }
        try {
            return (Double)this.timeFormat.parseObject(text);
        }
        catch (ParseException parseException) {
            try {
                Number n = (Number)this.decimalFormat.parseObject(text);
                if (n instanceof Double) {
                    return (Double)n;
                }
                return n.doubleValue();
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public String isValid(String text) {
        if (text == null) {
            return "Null";
        }
        if ((text = text.trim()).equals("")) {
            return null;
        }
        try {
            Double d = (Double)this.timeFormat.parseObject(text);
            if (d != null && d < 5.0) {
                return "Window size must at least 5 seconds.";
            }
            return null;
        }
        catch (ParseException d) {
            try {
                Number n = (Number)this.decimalFormat.parseObject(text);
                if (n != null && n.doubleValue() < 5.0) {
                    return "Window size must at least 5 seconds.";
                }
                return null;
            }
            catch (ParseException e) {
                return e.toString();
            }
        }
    }
}

