/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.ui.AddVariableToChartAction;
import org.simantics.charts.ui.ChartDropActionFactory;
import org.simantics.charts.ui.ChartVariable;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class SubscriptionDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    Resource container;
    Resource model;

    public SubscriptionDropParticipant(Resource container) {
        this.container = container;
        try {
            this.model = (Resource)Simantics.getSession().sync((ReadInterface)new PossibleModel(container));
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        if (!dtde.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            dtde.rejectDrag();
            return;
        }
        if ((dtde.getSourceActions() & 0x40000000) == 0) {
            dtde.rejectDrag();
            return;
        }
        try {
            Transferable t = dtde.getTransferable();
            Object data = t.getTransferData(LocalObjectTransferable.FLAVOR);
            data = LocalObjectTransfer.getTransfer().getObject();
            ArrayList<VariableReferenceDragItem> items = new ArrayList<VariableReferenceDragItem>();
            final List resources = ISelectionUtils.getPossibleKeys((Object)data, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
            if (!resources.isEmpty()) {
                items.addAll((Collection)Simantics.getSession().syncRequest((Read)new Read<List<IDragItem>>(){

                    public List<IDragItem> perform(ReadGraph graph) throws DatabaseException {
                        ArrayList<IDragItem> result = new ArrayList<IDragItem>();
                        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                        Resource targetModel = (Resource)graph.syncRequest((Read)new PossibleModel(SubscriptionDropParticipant.this.container));
                        if (targetModel != null) {
                            for (Resource r : resources) {
                                Resource model;
                                if (!graph.isInstanceOf(r, MOD.Subscription_Item) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(r))))) continue;
                                result.add((IDragItem)new SubscriptionItemDragItem(AddChartItem.createDescriptor(graph, r)));
                            }
                        }
                        return result;
                    }
                }));
            }
            if (data instanceof RVI) {
                VariableReferenceDragItem variableReferenceDragItem = new VariableReferenceDragItem((VariableReference)Simantics.getSession().sync((ReadInterface)new UnaryRead<RVI, VariableReference>((RVI)data){

                    public VariableReference perform(ReadGraph graph) throws DatabaseException {
                        return new VariableReference((RVI)this.parameter, Variables.getDatatype((ReadGraph)graph, (Resource)SubscriptionDropParticipant.this.model, (RVI)((RVI)this.parameter)), null);
                    }
                }));
                items.add(variableReferenceDragItem);
            } else {
                List wses;
                void var7_15;
                List vars;
                void var7_13;
                Object var7_11 = null;
                final List vars2 = ISelectionUtils.getPossibleKeys((Object)data, (IHintContext.Key)SelectionHints.KEY_MAIN, Variable.class);
                if (!vars2.isEmpty()) {
                    List list = (List)Simantics.getSession().syncRequest((Read)new Read<List<IDragItem>>(){

                        public List<IDragItem> perform(ReadGraph graph) throws DatabaseException {
                            return SubscriptionDropParticipant.toDragItems((Collection)graph.syncRequest(VariableReferences.variablesToReferences((Resource)SubscriptionDropParticipant.this.model, (List)vars2)));
                        }
                    });
                }
                if ((var7_13 == null || var7_13.isEmpty()) && !(vars = ISelectionUtils.getPossibleKeys((Object)data, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class)).isEmpty()) {
                    List list = (List)Simantics.getSession().syncRequest((Read)new Read<List<IDragItem>>(){

                        public List<IDragItem> perform(ReadGraph graph) throws DatabaseException {
                            List vars2 = PropertyVariablesImpl.resolve((ReadGraph)graph, (List)vars);
                            return SubscriptionDropParticipant.toDragItems((Collection)graph.syncRequest(VariableReferences.toReferences((Resource)SubscriptionDropParticipant.this.model, (List)vars2)));
                        }
                    });
                }
                if (var7_15 != null) {
                    items.addAll((Collection<VariableReferenceDragItem>)var7_15);
                }
                if (data instanceof ISelection && !(wses = ISelectionUtils.filterSelection((ISelection)((ISelection)data), WorkbenchSelectionElement.class)).isEmpty()) {
                    items.addAll((Collection)Simantics.getSession().syncRequest((Read)new Read<List<IDragItem>>(){

                        public List<IDragItem> perform(ReadGraph graph) throws DatabaseException {
                            ArrayList<Variable> wsevars = new ArrayList<Variable>();
                            ChartVariable av = new ChartVariable((RequestProcessor)graph);
                            for (WorkbenchSelectionElement wse : wses) {
                                Variable v = (Variable)wse.getContent((WorkbenchSelectionContentType)av);
                                if (v == null) continue;
                                wsevars.add(v);
                            }
                            return SubscriptionDropParticipant.toDragItems((Collection)graph.syncRequest(VariableReferences.variablesToReferences((Resource)SubscriptionDropParticipant.this.model, wsevars)));
                        }
                    }));
                }
            }
            if (items.isEmpty()) {
                dtde.rejectDrag();
            } else {
                for (IDragItem iDragItem : items) {
                    dp.add((Object)iDragItem);
                }
                dtde.acceptDrag(0x40000000);
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            dtde.rejectDrag();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
        for (IDragItem i : dp.getItemsByClass(SubscriptionItemDragItem.class)) {
            dp.remove((Object)i);
        }
        for (IDragItem i : dp.getItemsByClass(VariableReferenceDragItem.class)) {
            dp.remove((Object)i);
        }
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    public void drop(DropTargetDropEvent dtde, IDnDContext dp) {
        Collection subs = dp.getItemsByClass(SubscriptionItemDragItem.class);
        if (!subs.isEmpty()) {
            ArrayList<ChartItemDescriptor> cicr = new ArrayList<ChartItemDescriptor>();
            for (SubscriptionItemDragItem sidi : subs) {
                cicr.add((ChartItemDescriptor)sidi.getObject());
            }
            ChartDropActionFactory.addPlots(this.container, cicr, Collections.<Resource>emptySet()).run();
            dtde.dropComplete(true);
            return;
        }
        Collection vrdis = dp.getItemsByClass(VariableReferenceDragItem.class);
        if (!vrdis.isEmpty()) {
            ArrayList<VariableReference> refs = new ArrayList<VariableReference>();
            for (VariableReferenceDragItem vrdi : vrdis) {
                refs.add((VariableReference)vrdi.getObject());
            }
            Resource chart = this.container;
            try {
                AddVariableToChartAction a = new AddVariableToChartAction(chart, null, refs);
                a.init();
                a.run();
                dtde.dropComplete(true);
            }
            catch (DatabaseException e) {
                ShowMessage.showError((String)((Object)((Object)e)).getClass().getName(), (String)e.getMessage());
                dtde.dropComplete(true);
            }
            return;
        }
        dtde.rejectDrop();
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
        dtde.acceptDrag(0x40000000);
    }

    public int getAllowedOps() {
        return 0x40000000;
    }

    private static List<IDragItem> toDragItems(Collection<VariableReference> references) {
        ArrayList<IDragItem> result = new ArrayList<IDragItem>(references.size());
        for (VariableReference vr : references) {
            VariableReferenceDragItem di = new VariableReferenceDragItem(vr);
            result.add((IDragItem)di);
        }
        return result;
    }

    private static class SubscriptionItemDragItem
    extends DragItem<ChartItemDescriptor> {
        public SubscriptionItemDragItem(ChartItemDescriptor obj) {
            super((Object)obj);
        }
    }

    private static class VariableReferenceDragItem
    extends DragItem<VariableReference> {
        public VariableReferenceDragItem(VariableReference obj) {
            super((Object)obj);
        }
    }
}

