/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.swt.widgets.Shell;
import org.simantics.charts.editor.AddMilestoneDialog;
import org.simantics.charts.editor.TimeInputValidator;
import org.simantics.charts.editor.TimeSeriesEditor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.ontology.EventViewResource;
import org.simantics.event.util.EventWriteData;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;
import org.simantics.layer0.Layer0;
import org.simantics.trend.impl.TrendNode;
import org.simantics.ui.SimanticsUI;

public class AddMilestoneHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TimeSeriesEditor tse = this.getTSE(event);
        if (tse == null) {
            return null;
        }
        TrendNode tn = tse.trendNode;
        if (tn == null) {
            return null;
        }
        final Resource experiment = tse.chartData.run;
        if (experiment == null) {
            return null;
        }
        double time = tn.lastMouseHoverTime;
        Shell shell = tse.getSite().getShell();
        AddMilestoneDialog d = new AddMilestoneDialog(shell, time);
        int ok = d.open();
        if (ok != 0) {
            return null;
        }
        final String name = d.getName();
        final String desc = d.getDescription();
        Double time3 = TimeInputValidator.INSTANCE.parse(d.getTime());
        final double time4 = time3 == null ? 0.0 : time3;
        final boolean isBaseline = d.isBaseline();
        boolean isMilestone = true;
        Session session = SimanticsUI.getSession();
        final VirtualGraph vg = ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent("experiments");
        session.async((WriteInterface)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
                EventViewResource EVENTVIEW = EventViewResource.getInstance((ReadGraph)graph);
                Resource eventlog = graph.getPossibleObject(experiment, EVENT.IsEventProducerOf);
                if (eventlog == null) {
                    return;
                }
                EventWriteData data = new EventWriteData((ReadGraph)graph, eventlog, vg);
                data.prepareToWrite((WriteOnlyGraph)graph);
                Resource event = graph.newResource();
                graph.claim(event, L0.InstanceOf, EVENT.Event);
                graph.claimLiteral(event, L0.HasName, L0.String, (Object)("" + data.targetPos), (Binding)Bindings.STRING);
                graph.claimLiteral(event, L0.HasLabel, L0.String, (Object)name, (Binding)Bindings.STRING);
                graph.claimLiteral(event, L0.HasDescription, L0.String, (Object)desc, (Binding)Bindings.STRING);
                graph.claimLiteral(event, EVENT.HasTimestamp, EVENT.HasTimestamp_Inverse, EVENT.TimeStamp, (Object)time4, (Binding)Bindings.DOUBLE);
                graph.claim(event, EVENT.Milestone, event);
                if (isBaseline) {
                    graph.deny(eventlog, EVENT.EventLog_HasBaselineEvent);
                    graph.claim(eventlog, EVENT.EventLog_HasBaselineEvent, event);
                }
                graph.claim(event, EVENT.Event_type, null, EVENTVIEW.ManualEventType);
                graph.claimLiteral(event, EVENT.Event_message, (Object)name, (Binding)Bindings.STRING);
                graph.claim(event, EVENT.NoReturn, EVENT.NoReturn, event);
                graph.claim(data.targetSlice, L0.ConsistsOf, L0.PartOf, event);
                data.written();
                data.commit((WriteOnlyGraph)graph);
                graph.sync((WriteInterface)new CorrectMilestoneLabelsAction(eventlog, vg));
            }
        });
        return null;
    }

    TimeSeriesEditor getTSE(ExecutionEvent event) {
        Object eac = event.getApplicationContext();
        if (eac == null || !(eac instanceof EvaluationContext)) {
            return null;
        }
        EvaluationContext ec = (EvaluationContext)eac;
        Object editor = ec.getVariable("activeEditor");
        if (editor == null || !(editor instanceof TimeSeriesEditor)) {
            return null;
        }
        TimeSeriesEditor tse = (TimeSeriesEditor)((Object)editor);
        return tse;
    }
}

