/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.internal.xdot;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.IGraphPart;
import org.simantics.graphviz.internal.xdot.DrawCommand;
import org.simantics.graphviz.internal.xdot.DrawImage;
import org.simantics.graphviz.internal.xdot.FilledShape;
import org.simantics.graphviz.internal.xdot.SetFillColor;
import org.simantics.graphviz.internal.xdot.SetFont;
import org.simantics.graphviz.internal.xdot.SetPenColor;
import org.simantics.graphviz.internal.xdot.SetStyle;
import org.simantics.graphviz.internal.xdot.Shapes;
import org.simantics.graphviz.internal.xdot.Text;
import org.simantics.graphviz.internal.xdot.UnfilledShape;

public class DrawCommandParser {
    public static double readNumber(Reader s) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        while ((c = s.read()) != 32 && c > 0) {
            b.append((char)c);
        }
        return Double.parseDouble(b.toString());
    }

    public static int readInteger(Reader s) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        while ((c = s.read()) != 32 && c > 0) {
            b.append((char)c);
        }
        return Integer.parseInt(b.toString());
    }

    public static double[] readPoints(Reader s) throws IOException {
        int n = DrawCommandParser.readInteger(s);
        double[] points = new double[n * 2];
        int i = 0;
        while (i < n * 2) {
            points[i] = DrawCommandParser.readNumber(s);
            ++i;
        }
        return points;
    }

    public static String readString(Reader s) throws IOException {
        int n = DrawCommandParser.readInteger(s);
        s.read();
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            char c = (char)s.read();
            if (c == '\\') {
                c = (char)s.read();
            }
            chars[i] = c;
            ++i;
        }
        s.read();
        return new String(chars);
    }

    public static void parse(Collection<DrawCommand> commands, Reader s) throws IOException {
        while (true) {
            int commandChar = s.read();
            s.read();
            if (commandChar <= 0) {
                return;
            }
            switch (commandChar) {
                case 69: {
                    double x = DrawCommandParser.readNumber(s);
                    double y = DrawCommandParser.readNumber(s);
                    double w = DrawCommandParser.readNumber(s);
                    double h = DrawCommandParser.readNumber(s);
                    commands.add(new FilledShape(Shapes.createEllipse(x, y, w, h)));
                    break;
                }
                case 101: {
                    double x = DrawCommandParser.readNumber(s);
                    double y = DrawCommandParser.readNumber(s);
                    double w = DrawCommandParser.readNumber(s);
                    double h = DrawCommandParser.readNumber(s);
                    commands.add(new UnfilledShape(Shapes.createEllipse(x, y, w, h)));
                    break;
                }
                case 80: {
                    commands.add(new FilledShape(Shapes.createPolygon(DrawCommandParser.readPoints(s))));
                    break;
                }
                case 112: {
                    commands.add(new UnfilledShape(Shapes.createPolygon(DrawCommandParser.readPoints(s))));
                    break;
                }
                case 76: {
                    commands.add(new UnfilledShape(Shapes.createPolyline(DrawCommandParser.readPoints(s))));
                    break;
                }
                case 66: {
                    commands.add(new UnfilledShape(Shapes.createCubicSegments(DrawCommandParser.readPoints(s))));
                    break;
                }
                case 98: {
                    commands.add(new FilledShape(Shapes.createCubicSegments(DrawCommandParser.readPoints(s))));
                    break;
                }
                case 84: {
                    double x = DrawCommandParser.readNumber(s);
                    double y = DrawCommandParser.readNumber(s);
                    int j = DrawCommandParser.readInteger(s);
                    double w = DrawCommandParser.readNumber(s);
                    String text = DrawCommandParser.readString(s);
                    commands.add(new Text(x, y, j, w, text));
                    break;
                }
                case 67: {
                    commands.add(new SetFillColor(DrawCommandParser.readString(s)));
                    break;
                }
                case 99: {
                    commands.add(new SetPenColor(DrawCommandParser.readString(s)));
                    break;
                }
                case 70: {
                    double points = DrawCommandParser.readNumber(s);
                    String font = DrawCommandParser.readString(s);
                    commands.add(new SetFont(points, font));
                    break;
                }
                case 83: {
                    commands.add(new SetStyle(DrawCommandParser.readString(s)));
                    break;
                }
                case 73: {
                    double x = DrawCommandParser.readNumber(s);
                    double y = DrawCommandParser.readNumber(s);
                    double w = DrawCommandParser.readNumber(s);
                    double h = DrawCommandParser.readNumber(s);
                    String file = DrawCommandParser.readString(s);
                    commands.add(new DrawImage(x, y, w, h, file));
                }
            }
        }
    }

    public static void parse(Collection<DrawCommand> commands, String s) {
        if (s != null) {
            try {
                s = s.replace("\\\r\n", "");
                DrawCommandParser.parse(commands, new StringReader(s));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parse(Collection<DrawCommand> commands, IGraph graph) {
        for (IGraphPart part : graph.getParts()) {
            DrawCommandParser.parse(commands, part.get("_draw_"));
            DrawCommandParser.parse(commands, part.get("_ldraw_"));
            if (part instanceof Edge) {
                DrawCommandParser.parse(commands, part.get("_hdraw_"));
                DrawCommandParser.parse(commands, part.get("_tdraw_"));
                DrawCommandParser.parse(commands, part.get("_hldraw_"));
                DrawCommandParser.parse(commands, part.get("_tldraw_"));
                continue;
            }
            if (!(part instanceof IGraph)) continue;
            DrawCommandParser.parse(commands, (IGraph)((Object)part));
        }
    }

    private static void parse(Collection<DrawCommand> commands, Map<IGraphPart, Collection<DrawCommand>> partCommands, IGraph graph) {
        for (IGraphPart part : graph.getParts()) {
            ArrayList<DrawCommand> pCommands = new ArrayList<DrawCommand>();
            DrawCommandParser.parse(pCommands, part.get("_draw_"));
            DrawCommandParser.parse(pCommands, part.get("_ldraw_"));
            if (part instanceof Edge) {
                DrawCommandParser.parse(pCommands, part.get("_hdraw_"));
                DrawCommandParser.parse(pCommands, part.get("_tdraw_"));
                DrawCommandParser.parse(pCommands, part.get("_hldraw_"));
                DrawCommandParser.parse(pCommands, part.get("_tldraw_"));
            } else if (part instanceof IGraph) {
                DrawCommandParser.parse(commands, partCommands, (IGraph)((Object)part));
            }
            partCommands.put(part, pCommands);
            commands.addAll(pCommands);
        }
    }

    public static DrawCommand[] parse(Graph graph) {
        ArrayList<DrawCommand> commands = new ArrayList<DrawCommand>();
        DrawCommandParser.parse(commands, graph);
        return commands.toArray(new DrawCommand[commands.size()]);
    }

    public static void parse(Graph graph, Collection<DrawCommand> commands, Map<IGraphPart, Collection<DrawCommand>> partCommands) {
        DrawCommandParser.parse(commands, partCommands, graph);
    }
}

