/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.CompositeModule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.Locations;
import org.simantics.scl.osgi.CommandResponse;
import org.simantics.scl.osgi.SCLCommandSession;
import org.simantics.scl.runtime.procedure.Printer;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.ui.assist.SCLContentProposal;
import org.simantics.scl.ui.assist.SCLContentProposalAdapter;
import org.simantics.scl.ui.assist.SCLContentProposalProvider;
import org.simantics.scl.ui.assist.StyledTextContentAdapter;
import org.simantics.scl.ui.console.AbstractCommandConsole;
import org.simantics.scl.ui.console.ErrorAnnotation;

public class SCLConsole
extends AbstractCommandConsole {
    public static final String JOB_NAME = "org.simantics.scl.console.job";
    SCLCommandSession session = new SCLCommandSession(new Printer(){

        public void print(String text) {
            SCLConsole.this.appendOutput(String.valueOf(text) + "\n", null, null);
        }
    });

    public SCLConsole(Composite parent, int style) {
        super(parent, style);
        StyledTextContentAdapter styledTextContentAdapter = new StyledTextContentAdapter();
        SCLContentProposalProvider contentProvider = new SCLContentProposalProvider(this);
        try {
            SCLContentProposalAdapter contentProposalAdapter = new SCLContentProposalAdapter((Control)this.input, styledTextContentAdapter, contentProvider, KeyStroke.getInstance((String)"Ctrl+Space"), null);
            contentProposalAdapter.setAutoActivationDelay(200);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public ErrorAnnotation[] validate(String command) {
        if (command.isEmpty()) {
            return ErrorAnnotation.EMPTY_ARRAY;
        }
        SCLError[] errors = this.session.validate(command);
        if (errors.length == 0) {
            return ErrorAnnotation.EMPTY_ARRAY;
        }
        ErrorAnnotation[] annotations = new ErrorAnnotation[errors.length];
        int i = 0;
        while (i < errors.length) {
            int end;
            SCLError error = errors[i];
            int begin = Locations.beginOf((long)error.location);
            if (begin == Integer.MAX_VALUE) {
                begin = 0;
            }
            if ((end = Locations.endOf((long)error.location)) == Integer.MIN_VALUE) {
                end = command.length();
            }
            if (begin == end) {
                if (begin > 0) {
                    --begin;
                } else {
                    ++end;
                }
            }
            annotations[i] = new ErrorAnnotation(begin, end, error.description);
            ++i;
        }
        return annotations;
    }

    @Override
    public void execute(final String command) {
        Job job = new Job("Execute SCL"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Display display;
                    final CommandResponse response = SCLConsole.this.session.executeInJob(command);
                    if (!response.message.isEmpty() && !(display = Display.getDefault()).isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (display.isDisposed()) {
                                    return;
                                }
                                if (response.error) {
                                    SCLConsole.this.appendOutput(String.valueOf(response.message) + "\n", (this).SCLConsole.this.redColor, null);
                                } else {
                                    SCLConsole.this.appendOutput(String.valueOf(response.message) + "\n", null, null);
                                }
                            }
                        });
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return SCLConsole.JOB_NAME.equals(family);
            }
        };
        this.session.setJob(job);
        job.setUser(false);
        job.schedule();
    }

    public List<SCLContentProposal> getCompletionProposals(String prefix, boolean exact) {
        CompositeModule environmentModule = this.session.createEnvironmentModule();
        ArrayList<SCLValue> values = new ArrayList<SCLValue>();
        if (exact) {
            Name name = environmentModule.getResolver().getValue(prefix);
            if (name != null) {
                values.add(environmentModule.getEnvironment().getValue(name));
            }
        } else {
            environmentModule.getResolver().findValuesForPrefix(values, prefix);
        }
        String namespace = "";
        int pos = prefix.lastIndexOf(46);
        if (pos >= 0) {
            namespace = prefix.substring(0, pos + 1);
        }
        ArrayList<SCLContentProposal> proposals = new ArrayList<SCLContentProposal>(values.size());
        for (SCLValue value : values) {
            char c;
            String name;
            if (value.isPrivate() || (name = value.getName().name).isEmpty() || (c = name.charAt(0)) == '_' || c == '(' || Character.isLetter(c) && name.contains("$")) continue;
            proposals.add(new SCLContentProposal(String.valueOf(namespace) + value.getName().name, Types.removeForAll((Type)value.getType()).toString(), value.getName().module, value.getDocumentation()));
        }
        return proposals;
    }
}

