/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public final class Preferences {
    public static final String COMMAND_HISTORY = "COMMAND_HISTORY";
    private static final String DELIMITER = "\u00a4\u00a4\u00a4\u00a4";

    public static String join(Collection<String> s, String delimiter) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            builder.append(delimiter).append(iter.next());
        }
        return builder.toString();
    }

    public static Deque<String> decodePaths(String recentPathsPref) {
        LinkedList<String> result = new LinkedList<String>();
        String[] stringArray = recentPathsPref.split(DELIMITER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.add(s);
            ++n2;
        }
        return result;
    }

    public static String encodePaths(Collection<String> recentPaths) {
        return Preferences.join(recentPaths, DELIMITER);
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        TreeSet<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<String> it = iter.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (dups.add(path)) continue;
            it.remove();
        }
    }
}

