/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.browser;

import java.util.ArrayList;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.browser.HtmlFrame;
import org.simantics.scl.ui.browser.IndexDoc;

public class SCLDocumentationBrowser {
    public static final String LOCATION_PREFIX = "http://dev.simantics.org/scldoc/";
    Browser browser;
    ArrayList<String> locationHistory = new ArrayList();
    int locationHistoryPosition = -1;
    ArrayList<Runnable> runWhenCompleted = new ArrayList(2);
    Object runWhenCompletedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWhenCompleted(final String script) {
        Object object = this.runWhenCompletedLock;
        synchronized (object) {
            this.runWhenCompleted.add(new Runnable(){

                @Override
                public void run() {
                    SCLDocumentationBrowser.this.browser.execute(script);
                }
            });
        }
    }

    public SCLDocumentationBrowser(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(ProgressEvent event) {
                ArrayList<Runnable> rs;
                Object object = SCLDocumentationBrowser.this.runWhenCompletedLock;
                synchronized (object) {
                    rs = SCLDocumentationBrowser.this.runWhenCompleted;
                    SCLDocumentationBrowser.this.runWhenCompleted = new ArrayList(2);
                }
                for (Runnable r : rs) {
                    r.run();
                }
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location.startsWith("about:blank")) {
                    return;
                }
                if (SCLDocumentationBrowser.this.locationHistoryPosition < 0 || !location.equals(SCLDocumentationBrowser.this.locationHistory.get(SCLDocumentationBrowser.this.locationHistoryPosition))) {
                    ++SCLDocumentationBrowser.this.locationHistoryPosition;
                    while (SCLDocumentationBrowser.this.locationHistory.size() > SCLDocumentationBrowser.this.locationHistoryPosition) {
                        SCLDocumentationBrowser.this.locationHistory.remove(SCLDocumentationBrowser.this.locationHistory.size() - 1);
                    }
                    SCLDocumentationBrowser.this.locationHistory.add(location);
                }
                if (location.startsWith(SCLDocumentationBrowser.LOCATION_PREFIX)) {
                    String html;
                    String fragment;
                    int hashPos = (location = location.substring(SCLDocumentationBrowser.LOCATION_PREFIX.length())).indexOf(35);
                    if (hashPos >= 0) {
                        fragment = location.substring(hashPos);
                        location = location.substring(0, hashPos);
                    } else {
                        fragment = null;
                    }
                    if (location.endsWith(".html")) {
                        location = location.substring(0, location.length() - 5);
                    }
                    if (location.equals("index")) {
                        html = IndexDoc.getIndex();
                    } else {
                        Module module = SCLOsgi.INSTANCE.getModuleLoader().loadModule(location);
                        html = HtmlFrame.toHtml(module);
                    }
                    SCLDocumentationBrowser.this.browser.setText(html);
                    if (fragment != null) {
                        SCLDocumentationBrowser.this.executeWhenCompleted("location.hash = \"" + fragment + "\";");
                    }
                    event.doit = false;
                }
            }
        });
        this.browser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x10000) != 0) {
                    if (e.keyCode == 0x1000003) {
                        if (SCLDocumentationBrowser.this.locationHistoryPosition > 0) {
                            SCLDocumentationBrowser.this.browser.setUrl(SCLDocumentationBrowser.this.locationHistory.get(--SCLDocumentationBrowser.this.locationHistoryPosition));
                        }
                    } else if (e.keyCode == 0x1000004 && SCLDocumentationBrowser.this.locationHistoryPosition < SCLDocumentationBrowser.this.locationHistory.size() - 1) {
                        SCLDocumentationBrowser.this.browser.setUrl(SCLDocumentationBrowser.this.locationHistory.get(++SCLDocumentationBrowser.this.locationHistoryPosition));
                    }
                }
            }
        });
    }

    public void setLocation(String path) {
        this.browser.setUrl(LOCATION_PREFIX + path);
    }
}

