/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.browser;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.browser.HtmlFrame;

public class IndexDoc {
    private static String index;

    public static String getIndex() {
        if (index == null) {
            IndexDoc.createIndex();
        }
        return index;
    }

    private static void createIndex() {
        THashMap packageMap = new THashMap();
        for (String module : SCLOsgi.INSTANCE.getAllModules()) {
            String name;
            String pack;
            int slashPos = module.lastIndexOf(47);
            if (slashPos >= 0) {
                pack = module.substring(0, slashPos);
                name = module.substring(slashPos + 1);
            } else {
                pack = "";
                name = module;
            }
            ArrayList<String> modules = (ArrayList<String>)packageMap.get((Object)pack);
            if (modules == null) {
                modules = new ArrayList<String>();
                packageMap.put((Object)pack, modules);
            }
            modules.add(name);
        }
        ArrayList packages = new ArrayList(packageMap.keySet());
        Collections.sort(packages);
        StringBuffer b = new StringBuffer();
        Matcher m = HtmlFrame.TEMPLATE_PATTERN.matcher(HtmlFrame.SCL_DOC_HTML);
        boolean firstTitle = true;
        while (m.find()) {
            String el = m.group();
            if (el.equals("#STYLE")) {
                m.appendReplacement(b, Matcher.quoteReplacement(HtmlFrame.SCL_DOC_CSS));
                continue;
            }
            if (el.equals("#DESCRIPTION")) {
                m.appendReplacement(b, "");
                for (String pack : packages) {
                    if (!pack.isEmpty()) {
                        b.append("<h1 id=\"").append(pack).append("\">").append(pack).append("</h1>\n");
                    }
                    ArrayList modules = (ArrayList)packageMap.get((Object)pack);
                    Collections.sort(modules);
                    b.append("<ul>\n");
                    for (String module : modules) {
                        b.append("<li><a href=\"");
                        if (!pack.isEmpty()) {
                            b.append(pack).append('/');
                        }
                        b.append(module).append("\">").append(module).append("</a></li>\n");
                    }
                    b.append("</ul>\n");
                }
                continue;
            }
            if (el.equals("#TOC")) {
                m.appendReplacement(b, "");
                b.append("<ul>\n");
                for (String pack : packages) {
                    if (pack.isEmpty()) continue;
                    b.append("<li><a href=\"#").append(pack).append("\">").append(pack).append("</a></li>\n");
                }
                b.append("</ul>\n");
                continue;
            }
            if (!el.equals("#TITLE")) continue;
            if (firstTitle) {
                m.appendReplacement(b, "index");
                firstTitle = false;
                continue;
            }
            m.appendReplacement(b, "SCL Documentation Index");
        }
        m.appendTail(b);
        index = b.toString();
    }
}

