/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.browser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.Module;

public class HtmlFrame {
    static final String SCL_DOC_HTML = HtmlFrame.load("SclDoc.html");
    static final String SCL_DOC_CSS = HtmlFrame.load("SclDoc.css");
    static final Pattern TEMPLATE_PATTERN = Pattern.compile("#[A-Za-z]+");

    public static String toHtml(Module module) {
        Documentation documentation = module.getDocumentation();
        if (documentation == null) {
            documentation = new Documentation("No documentation.", "");
        }
        StringBuffer b = new StringBuffer();
        Matcher m = TEMPLATE_PATTERN.matcher(SCL_DOC_HTML);
        while (m.find()) {
            String el = m.group();
            if (el.equals("#STYLE")) {
                m.appendReplacement(b, Matcher.quoteReplacement(SCL_DOC_CSS));
                continue;
            }
            if (el.equals("#DESCRIPTION")) {
                m.appendReplacement(b, Matcher.quoteReplacement(documentation.documentation));
                continue;
            }
            if (el.equals("#TOC")) {
                m.appendReplacement(b, Matcher.quoteReplacement(documentation.tableOfContents));
                continue;
            }
            if (!el.equals("#TITLE")) continue;
            m.appendReplacement(b, Matcher.quoteReplacement(module.getModuleName()));
        }
        m.appendTail(b);
        return b.toString();
    }

    private static String load(String name) {
        try {
            int count;
            InputStream stream = HtmlFrame.class.getResourceAsStream(name);
            byte[] temp = new byte[1024];
            int pos = 0;
            while ((count = stream.read(temp, pos, temp.length - pos)) > 0) {
                if ((pos += count) != temp.length) continue;
                temp = Arrays.copyOf(temp, temp.length * 2);
            }
            stream.close();
            return new String(temp, 0, pos, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

