/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.assist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.simantics.scl.ui.assist.SCLContentProposalProvider;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private static final boolean COMPUTE_TEXT_USING_CLIENTAREA = !"carbon".equals(SWT.getPlatform());

    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ((StyledText)control).setText(text);
        ((StyledText)control).setSelection(new Point(cursorPosition, cursorPosition));
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        StyledText combo = (StyledText)control;
        String contents = combo.getText();
        Point selection = combo.getSelection();
        int contentsPosition = selection.x;
        contents = contents.replace("\n", "");
        contents = contents.replace("\r", "");
        String[] splitContents = contents.split(" ");
        String prefix = SCLContentProposalProvider.findPrefix(splitContents[splitContents.length - 1], contentsPosition);
        contents = String.valueOf(contents.substring(0, contentsPosition - prefix.length())) + text + contents.substring(contentsPosition) + "\b";
        combo.setText(contents);
        selection.y = selection.x = contentsPosition - prefix.length() + cursorPosition;
        combo.setSelection(selection);
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getSelection().x;
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText combo = (StyledText)control;
        int position = combo.getSelection().y;
        String contents = combo.getText();
        GC gc = new GC((Drawable)combo);
        gc.setFont(combo.getFont());
        Point extent = gc.textExtent(contents.substring(0, Math.min(position, contents.length())));
        gc.dispose();
        if (COMPUTE_TEXT_USING_CLIENTAREA) {
            return new Rectangle(combo.getClientArea().x + extent.x, combo.getClientArea().y, 1, combo.getClientArea().height);
        }
        return new Rectangle(extent.x, 0, 1, combo.getSize().y);
    }

    public void setCursorPosition(Control control, int index) {
        ((StyledText)control).setSelection(new Point(index, index));
    }

    public Point getSelection(Control control) {
        return ((StyledText)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((StyledText)control).setSelection(range);
    }
}

