/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.assist;

import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.simantics.scl.ui.assist.SCLContentProposal;
import org.simantics.scl.ui.console.SCLConsole;

public class SCLContentProposalProvider
implements IContentProposalProvider {
    private SCLConsole console;

    public SCLContentProposalProvider(SCLConsole console) {
        this.console = console;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        THashSet proposals = new THashSet();
        while (position > 0 && contents.charAt(position - 1) == ' ') {
            --position;
        }
        int sp = position;
        while (sp > 0) {
            char c = contents.charAt(sp - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '_' && c != '.' && c != '=' && c != '\"') break;
            --sp;
        }
        String prefix = contents.substring(sp, position);
        position = sp;
        proposals.addAll(this.console.getCompletionProposals(prefix, false));
        if (position > 0) {
            String[] stringArray = contents.substring(0, position).split("[ \t\r\n]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!id.isEmpty()) {
                    proposals.addAll(this.console.getCompletionProposals(id, true));
                }
                ++n2;
            }
        }
        SCLContentProposal[] proposalArray = (SCLContentProposal[])proposals.toArray((Object[])new SCLContentProposal[proposals.size()]);
        Arrays.sort(proposalArray, new Comparator<ContentProposal>(){

            @Override
            public int compare(ContentProposal o1, ContentProposal o2) {
                return o1.getContent().compareTo(o2.getContent());
            }
        });
        return proposalArray;
    }

    public static String findPrefix(String contents, int position) {
        if (position > contents.length()) {
            position = contents.length();
        }
        while (position > 0 && contents.charAt(position - 1) == ' ') {
            --position;
        }
        int sp = position;
        while (sp > 0) {
            char c = contents.charAt(sp - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '_' && c != '.' && c != '=' && c != '\"') break;
            --sp;
        }
        return contents.substring(sp, position);
    }
}

