/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.tester;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.wiki.ui.ReportFactory;

public class ReportPropertyTester
extends PropertyTester {
    private static final boolean DEBUG = false;
    protected static final String IS_REPORTABLE = "isReportable";

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        NodeContext ctx = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)receiver, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (ctx == null) {
            return false;
        }
        final Statement statement = (Statement)ctx.getAdapter(Statement.class);
        if (statement == null) {
            return false;
        }
        Session session = Simantics.peekSession();
        if (session == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return ReportPropertyTester.this.doTest(g, statement, property, args, expectedValue);
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    protected boolean doTest(ReadGraph g, Statement statement, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (IS_REPORTABLE.equals(property)) {
            ReportFactory rf = (ReportFactory)g.getPossibleAdapter(statement.getPredicate(), ReportFactory.class);
            return rf != null;
        }
        return false;
    }
}

