/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.objects;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.layer0.adapter.RuntimeValuations;
import org.simantics.db.layer0.adapter.TrendVariable;
import org.simantics.db.layer0.request.PossibleActiveExperimentPath;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.Trend2DNode;
import org.simantics.scenegraph.swing.JFreeTrendNode;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Segment;
import org.simantics.utils.datastructures.SegmentSet;
import org.simantics.wiki.ui.objects.Renderer;

public class TrendRenderer
implements Renderer {
    protected String dataRef;
    protected int width;
    protected int height;
    protected String title = "Trend";
    protected Component component = null;
    protected List<Trend2DNode.TrendPoint> points = null;

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("data")) {
            this.dataRef = value;
            this.loadTrendData();
        } else if (name.equals("title")) {
            this.title = value;
        } else if (name.equals("width")) {
            this.width = Integer.parseInt(value);
        } else if (name.equals("height")) {
            this.height = Integer.parseInt(value);
        }
    }

    public void loadTrendData() {
        ISessionContext sessionContext = SimanticsUI.getSessionContextProvider().getSessionContext();
        IProject project = (IProject)sessionContext.getHint(ProjectKeys.KEY_PROJECT);
        Session session = sessionContext.getSession();
        Layer0 b = (Layer0)session.getService(Layer0.class);
        RuntimeValuations rv = (RuntimeValuations)session.getService(RuntimeValuations.class);
        try {
            SimulationResource SIMU = SimulationResource.getInstance((RequestProcessor)session);
            Resource model = (Resource)session.syncRequest((Read)new PossibleObjectWithType((Resource)project.get(), b.ConsistsOf, SIMU.Model));
            String modelURI = (String)session.syncRequest((Read)new ResourceToURI(model));
            String experiment = (String)session.syncRequest((Read)new PossibleActiveExperimentPath(model));
            String variableRef = String.valueOf(this.dataRef) + Variables.Role.CHILD.getIdentifier() + "Value";
            TrendVariable var = rv.getVariable(modelURI, experiment, variableRef);
            SegmentSet segments = var.getDataSegments();
            Segment[] segmentArr = segments.toArray();
            this.points = new ArrayList<Trend2DNode.TrendPoint>();
            int rangeIndex = 0;
            while (rangeIndex < segmentArr.length) {
                Segment segment = segmentArr[rangeIndex];
                ++rangeIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public Component getComponent() {
        if (this.component == null && this.points != null) {
            this.component = new TrendComponent(this.title, this.width, this.height, this.points);
        } else {
            ((TrendComponent)this.component).setPoints(this.points);
        }
        return this.component;
    }

    public void reset(int availableWidth, int availableHeight) {
    }

    public void resume() {
    }

    public void suspend() {
    }

    public static class TrendComponent
    extends JComponent {
        private static final long serialVersionUID = -941571681987890363L;
        protected List<Trend2DNode.TrendPoint> points;
        int width = 0;
        int height = 0;
        final JFreeTrendNode node;

        public TrendComponent(String title, int width, int height, List<Trend2DNode.TrendPoint> points) {
            this.setSize(width, height);
            this.width = width;
            this.height = height;
            this.points = points;
            G2DSceneGraph sg = new G2DSceneGraph();
            this.addMouseListener((MouseListener)sg.getEventDelegator());
            this.addMouseMotionListener((MouseMotionListener)sg.getEventDelegator());
            this.addMouseWheelListener((MouseWheelListener)sg.getEventDelegator());
            this.addKeyListener((KeyListener)sg.getEventDelegator());
            this.addFocusListener((FocusListener)sg.getEventDelegator());
            sg.setRootPane((JComponent)this);
            this.node = (JFreeTrendNode)sg.addNode(JFreeTrendNode.class);
            this.node.setTitle(title);
            this.node.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width - 1, height - 1));
        }

        public void setPoints(List<Trend2DNode.TrendPoint> points) {
            this.points = points;
        }

        @Override
        public void paint(Graphics g) {
            this.setSize(this.width, this.height);
            Graphics2D g2d = (Graphics2D)g.create();
            if (this.points == null) {
                return;
            }
            this.node.updatePoints(this.points);
            this.node.render(g2d);
            g2d.setColor(Color.BLACK);
            g2d.draw(new Rectangle2D.Double(0.0, 0.0, this.width - 1, this.height - 1));
        }

        public void finalize() {
        }
    }
}

