/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.objects;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorListener;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.dnd.DragInteractor;
import org.simantics.g2d.dnd.DropInteractor;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.scenegraph.adapters.ISceneGraphProvider;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.adapter.AWTFocusAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTKeyEventAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTMouseEventAdapter;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.wiki.ui.objects.Renderer;

public class DiagramRenderer
implements Renderer {
    protected String resourceURI;
    protected String layer;
    protected int width;
    protected int height;
    protected JComponent component = null;
    private ICanvasSceneGraphProvider provider = null;
    private G2DSceneGraph sg = null;
    protected IHintContext hintCtx = new HintContext();
    protected SyncListenerList<IChassisListener> listeners = new SyncListenerList(IChassisListener.class);
    protected DropInteractor drop;
    protected DragInteractor drag;
    AWTMouseEventAdapter mouseAdapter;
    AWTKeyEventAdapter keyAdapter;
    AWTFocusAdapter focusAdapter;
    boolean hookKeyEvents = false;
    IMouseCursorListener cursorListener = new IMouseCursorListener(){

        public void onCursorSet(IMouseCursorContext sender, int mouseId, Cursor cursor) {
            if (mouseId == 0) {
                DiagramRenderer.this.component.setCursor(cursor);
            }
        }
    };
    private transient boolean dirty = false;
    protected IContentContext.IContentListener contentListener = new IContentContext.IContentListener(){

        public void onDirty(IContentContext sender) {
            DiagramRenderer.this.dirty = true;
        }
    };
    protected IEventQueue.IEventQueueListener queueListener = new IEventQueue.IEventQueueListener(){

        public void onEventAdded(IEventQueue queue, Event e, int index) {
        }

        public void onQueueEmpty(IEventQueue queue) {
            if (DiagramRenderer.this.dirty) {
                RepaintManager rm = RepaintManager.currentManager(DiagramRenderer.this.component);
                rm.markCompletelyDirty(DiagramRenderer.this.component);
            }
        }
    };

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("data")) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (value != null) {
                String[] optionPairs;
                String[] stringArray = optionPairs = value.split("\\s*\\|\\s*");
                int n = optionPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String optionPair = stringArray[n2];
                    String[] keyValue = optionPair.split("\\s*=\\s*");
                    if (keyValue.length == 2) {
                        String key = keyValue[0].trim();
                        String v = keyValue[1].trim();
                        params.put(key, v);
                    }
                    ++n2;
                }
            }
            this.resourceURI = (String)params.get("resource");
            this.layer = (String)params.get("layer");
            this.loadDiagram();
        } else if (name.equals("width")) {
            this.width = Integer.parseInt(value);
        } else if (name.equals("height")) {
            this.height = Integer.parseInt(value);
        }
    }

    protected void loadDiagram() {
        try {
            final Resource resource = (Resource)SimanticsUI.getSession().syncRequest(Queries.resource((String)this.resourceURI));
            this.provider = (ICanvasSceneGraphProvider)SimanticsUI.getSession().syncRequest((Read)new Read<ISceneGraphProvider>(){

                public ISceneGraphProvider perform(ReadGraph g) throws DatabaseException {
                    ISceneGraphProvider provider = null;
                    provider = (ISceneGraphProvider)g.adapt(resource, ISceneGraphProvider.class);
                    return provider;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.sg = new G2DSceneGraph();
        this.provider.initializeSceneGraph(this.sg, this.layer);
    }

    public void destroy() {
        this.provider.dispose();
        this.provider = null;
        this.sg = null;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new DiagramComponent(this.width, this.height, this.sg);
            ICanvasContext ctx = this.provider.getCanvasContext();
            ctx.getHintStack().addHintContext(this.hintCtx, 0);
            ctx.getContentContext().addPaintableContextListener(this.contentListener);
            ctx.getEventQueue().addQueueListener(this.queueListener);
            ctx.getMouseCursorContext().addCursorListener(this.cursorListener);
            this.mouseAdapter = new AWTMouseEventAdapter((Object)ctx, ctx.getEventQueue());
            if (this.hookKeyEvents) {
                this.keyAdapter = new AWTKeyEventAdapter((Object)ctx, ctx.getEventQueue());
                this.component.addKeyListener((KeyListener)this.keyAdapter);
            }
            this.focusAdapter = new AWTFocusAdapter((Object)ctx, ctx.getEventQueue());
            this.component.addMouseListener((MouseListener)this.mouseAdapter);
            this.component.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.component.addMouseWheelListener((MouseWheelListener)this.mouseAdapter);
            this.component.addFocusListener((FocusListener)this.focusAdapter);
        }
        System.out.println("getComponent() " + this.component.getWidth() + ", " + this.component.getHeight());
        return this.component;
    }

    public void reset(int availableWidth, int availableHeight) {
    }

    public void resume() {
    }

    public void suspend() {
    }

    public static class DiagramComponent
    extends JComponent {
        private static final long serialVersionUID = -941571681987890363L;
        final G2DSceneGraph sg;
        int width = 0;
        int height = 0;

        public DiagramComponent(int width, int height, G2DSceneGraph sg) {
            this.setSize(width, height);
            this.width = width;
            this.height = height;
            this.sg = sg;
            this.addMouseListener((MouseListener)sg.getEventDelegator());
            this.addMouseMotionListener((MouseMotionListener)sg.getEventDelegator());
            this.addMouseWheelListener((MouseWheelListener)sg.getEventDelegator());
            this.addKeyListener((KeyListener)sg.getEventDelegator());
            this.addFocusListener((FocusListener)sg.getEventDelegator());
            sg.setRootPane((JComponent)this);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.BLACK);
            this.setSize(this.width, this.height);
            g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setClip(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
            this.sg.render(g2d);
            g2d.draw(new Rectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1));
        }
    }
}

