/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.export;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.wiki.ui.ReportFactory;

public class ReportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        NodeContext ctx = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selection, NodeContext.class);
        if (ctx == null) {
            return null;
        }
        final Statement statement = (Statement)ctx.getAdapter(Statement.class);
        if (statement == null) {
            return null;
        }
        ReportFactory.Report report = null;
        try {
            report = (ReportFactory.Report)SimanticsUI.getSession().syncRequest((Read)new Read<ReportFactory.Report>(){

                public ReportFactory.Report perform(ReadGraph graph) throws DatabaseException {
                    ReportFactory.Report report = null;
                    ReportFactory rf = (ReportFactory)graph.adapt(statement.getPredicate(), ReportFactory.class);
                    report = rf.createReport(graph, statement.getObject());
                    return report;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        System.out.println(report.getContent());
        return null;
    }
}

