/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.PrintableHtmlPanel;
import org.simantics.wiki.ui.browser.SimanticsHtmlRendererContext;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

@Deprecated
public class FullPDFExport
extends Wizard
implements IExportWizard {
    static final String[] EXTENSIONS = new String[]{"*.pdf"};
    Session session;
    Collection<Resource> roots = new ArrayList<Resource>();
    String error;
    PDFExportPage page;
    String recentExportPath;
    private static final String PREFERENCE_STORE = "org.simantics.wiki.ui.export";
    private static final String RECENT_EXPORT_LOCATIONS = "RECENT_EXPORT_LOCATIONS";

    private void readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), PREFERENCE_STORE);
        this.recentExportPath = store.getString(RECENT_EXPORT_LOCATIONS);
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), PREFERENCE_STORE);
        store.putValue(RECENT_EXPORT_LOCATIONS, this.recentExportPath);
        if (store.needsSaving()) {
            store.save();
        }
    }

    public boolean performFinish() {
        File file = new File(this.page.fileName.getText());
        try {
            block12: {
                String markup = "";
                for (final Resource r : this.roots) {
                    markup = (String)this.session.syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                            String markup = (String)graph.getRelatedValue(r, DOC.HasDocumentation, (Binding)Bindings.STRING);
                            return markup;
                        }
                    });
                }
                String finalMarkup = SimanticsDialect.INSTANCE.apply(null, null, markup);
                MarkupParser markupParser = new MarkupParser();
                MediaWikiLanguage language = new MediaWikiLanguage();
                markupParser.setMarkupLanguage((MarkupLanguage)language);
                String htmlContent = markupParser.parseToHtml(finalMarkup);
                PrintableHtmlPanel component = new PrintableHtmlPanel();
                component.setHtml(htmlContent, "http://localhost", new SimanticsHtmlRendererContext(component, null));
                Document document = new Document(PageSize.A4, 36.0f, 36.0f, 36.0f, 36.0f);
                PdfWriter writer = null;
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                    document.open();
                    PdfContentByte cb = writer.getDirectContent();
                    Graphics2D g2d = cb.createGraphicsShapes(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                    component.print(g2d);
                    g2d.dispose();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    document.close();
                    writer.close();
                    break block12;
                }
                catch (DocumentException e) {
                    try {
                        e.printStackTrace();
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        document.close();
                        writer.close();
                    }
                }
                document.close();
                writer.close();
            }
            this.recentExportPath = this.page.fileName.getText();
            this.writePreferences();
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Export failed", (String)e.getMessage());
            return false;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Export failed", (String)e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences();
        this.setWindowTitle("PDF export");
        this.session = SimanticsUI.getSession();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (s instanceof Resource) {
                this.roots.add((Resource)s);
            } else if (s instanceof IAdaptable) {
                this.roots.add((Resource)((IAdaptable)s).getAdapter(Resource.class));
            } else {
                this.error = "Selection contains items that are not resources.";
            }
            ++n2;
        }
    }

    public void addPages() {
        this.page = new PDFExportPage("Export destination");
        this.addPage((IWizardPage)this.page);
    }

    class PDFExportPage
    extends WizardPage {
        Composite composite;
        Text fileName;

        public PDFExportPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && FullPDFExport.this.error == null;
        }

        public PDFExportPage(String pageName) {
            super(pageName);
            this.setPageComplete(!FullPDFExport.this.recentExportPath.isEmpty());
        }

        public void createControl(Composite parent) {
            this.setTitle("Export graph");
            if (FullPDFExport.this.error != null) {
                this.setErrorMessage(FullPDFExport.this.error);
            }
            this.composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.composite);
            Label label = new Label(this.composite, 0);
            label.setText("Select the export destination:");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
            this.fileName = new Text(this.composite, 2048);
            this.fileName.setText(FullPDFExport.this.recentExportPath);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fileName);
            this.fileName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PDFExportPage.this.setPageComplete(!PDFExportPage.this.fileName.getText().isEmpty());
                    FullPDFExport.this.getContainer().updateButtons();
                }
            });
            Button browseButton = new Button(this.composite, 8);
            browseButton.setText("Browse..");
            GridDataFactory.fillDefaults().applyTo((Control)browseButton);
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(PDFExportPage.this.composite.getShell(), 8192);
                    dialog.setText("Export destination");
                    dialog.setFileName(PDFExportPage.this.fileName.getText());
                    dialog.setFilterExtensions(EXTENSIONS);
                    String newFileName = dialog.open();
                    if (newFileName != null) {
                        PDFExportPage.this.fileName.setText(newFileName);
                    }
                }
            });
            this.setControl((Control)this.composite);
        }
    }
}

