/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.editor;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.lobobrowser.html.renderer.RBlock;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.BrowserComponent;
import org.simantics.wiki.ui.editor.IExportable;
import org.simantics.wiki.ui.editor.IPrintable;
import org.simantics.wiki.ui.editor.WikiExportPDFAction;
import org.simantics.wiki.ui.editor.WikiPrintAction;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class WikiViewer
extends ResourceEditorPart
implements IExportable,
IPrintable {
    public static final String EDITOR_ID = "org.simantics.wiki.ui.viewer";
    protected ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    protected String markup = "";
    protected BrowserComponent browser = null;

    public void createPartControl(Composite parent) {
        WikiPrintAction printAction = new WikiPrintAction(this);
        WikiExportPDFAction exportAction = new WikiExportPDFAction(this);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)printAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.EXPORT.getId(), (IAction)exportAction);
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.browser = new BrowserComponent(parent, 0, null);
        this.browser.syncPopulate();
        this.browser.setLayoutData(new GridData(4, 4, true, true));
        Logger.getLogger("org.lobobrowser").setLevel(Level.OFF);
        Logger.getLogger("com.steadystate").setLevel(Level.OFF);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.loadInputResource();
    }

    protected static String readDocuments(ReadGraph g, Resource root, int depth) throws ManyObjectsForFunctionalRelationException, ServiceException, BindingException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)g);
        String name = (String)g.getPossibleRelatedValue(root, l0.HasName, (Binding)Bindings.STRING);
        String doc = (String)g.getPossibleRelatedValue(root, DOC.HasDocumentation, (Binding)Bindings.STRING);
        if (doc == null) {
            doc = "";
        }
        String header = "";
        int i = 0;
        while (i <= depth && i < 5) {
            header = String.valueOf(header) + "=";
            ++i;
        }
        Collection children = g.getObjects(root, l0.ConsistsOf);
        for (Resource child : children) {
            String tmp = WikiViewer.readDocuments(g, child, depth + 1);
            if (tmp.length() <= 0) continue;
            doc = String.valueOf(doc) + "\n" + tmp;
        }
        if (name != null && doc.length() > 0) {
            doc = String.valueOf(header) + name + header + "\n" + doc + "\n";
        }
        return doc;
    }

    protected void loadInputResource() {
        Session session = this.getSession();
        final Resource input = this.getInputResource();
        try {
            this.markup = (String)session.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph g) throws DatabaseException {
                    return WikiViewer.readDocuments(g, input, 0);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.updateBrowserView();
    }

    protected void updateBrowserView() {
        try {
            String finalMarkup = SimanticsDialect.INSTANCE.apply(null, null, this.markup);
            MarkupParser markupParser = new MarkupParser();
            MediaWikiLanguage language = new MediaWikiLanguage();
            markupParser.setMarkupLanguage((MarkupLanguage)language);
            final String htmlContent = markupParser.parseToHtml(finalMarkup);
            if (this.browser != null) {
                this.browser.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WikiViewer.this.browser.setText(htmlContent);
                    }
                });
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void export(Document document, PdfWriter writer) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        int marginLeft = 20;
        int marginRight = 20;
        int marginTop = 10;
        int marginBottom = 45;
        int contentWidth = (int)PageSize.A4.getWidth() - marginLeft - marginRight;
        int contentHeight = (int)PageSize.A4.getHeight() - marginTop - marginBottom;
        ((RBlock)this.browser.getPanel().getBlockRenderable()).layout(contentWidth, contentHeight, false, true, 0, 0, false);
        Rectangle bounds = ((RBlock)this.browser.getPanel().getBlockRenderable()).getBounds();
        org.eclipse.swt.graphics.Rectangle browserBounds = this.browser.getBounds();
        this.browser.setBounds(0, 0, contentWidth, contentHeight);
        this.browser.getPanel().getBlockRenderable().relayout();
        PdfTemplate template = null;
        int page = 0;
        while ((double)page < Math.floor((double)((float)bounds.height / (float)contentHeight) + 0.99)) {
            template = cb.createTemplate(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            Graphics2D g2d = template.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            g2d.translate(marginLeft, marginTop);
            g2d.setClip(0, 0, contentWidth, contentHeight);
            this.browser.getPanel().getBlockRenderable().setOrigin(0, -page * contentHeight);
            this.browser.getPanel().getBlockRenderable().paintTranslated((Graphics)g2d);
            g2d.dispose();
            cb.addTemplate(template, 0.0f, 0.0f);
            document.newPage();
            ++page;
        }
        this.browser.setBounds(browserBounds);
    }

    @Override
    public void print(final Printer printer) {
        this.browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Point size = WikiViewer.this.browser.getSize();
                Image image = new Image((Device)WikiViewer.this.browser.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)WikiViewer.this.browser);
                gc.copyArea(image, 0, 0);
                gc.dispose();
                Point screenDPI = WikiViewer.this.browser.getDisplay().getDPI();
                Point printerDPI = printer.getDPI();
                float scaleX = printerDPI.x / screenDPI.x;
                float scaleY = printerDPI.y / screenDPI.y;
                ImageData imageData = image.getImageData();
                Image printImage = new Image((Device)printer, imageData);
                printer.startJob("wiki");
                printer.startPage();
                GC pgc = new GC((Drawable)printer);
                Transform transform = new Transform((Device)printer);
                pgc.getTransform(transform);
                transform.scale(scaleX, scaleY);
                pgc.setTransform(transform);
                pgc.drawImage(printImage, 0, 0);
                printer.endPage();
                printer.endJob();
                printer.dispose();
                pgc.dispose();
                image.dispose();
                printImage.dispose();
            }
        });
    }
}

