/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.editor;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.lobobrowser.html.renderer.RBlock;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.simantics.wiki.ui.DocumentFactory;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.BrowserComponent;
import org.simantics.wiki.ui.editor.IExportable;
import org.simantics.wiki.ui.editor.IPrintable;
import org.simantics.wiki.ui.editor.NavigationHandler;
import org.simantics.wiki.ui.editor.WikiExportPDFAction;
import org.simantics.wiki.ui.editor.WikiFontUtil;
import org.simantics.wiki.ui.editor.WikiPrintAction;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class WikiEditor
extends ResourceEditorPart
implements IExportable,
IPrintable,
NavigationHandler {
    private static final String SOURCE_SELECTED_TAB = "Source";
    private static final String DOCUMENT_TAB_TITLE = "Document";
    private static final String PROP_PREVIOUSLY_SELECTED_TAB = "wiki.editor.selectedTab";
    private static final String DEFAULT_SELECTED_TAB = "Source";
    public static final String EDITOR_ID = "org.simantics.wiki.ui.editor";
    protected ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    protected ResourceManager resourceManager;
    protected String markup = "";
    protected CTabFolder folder;
    protected BrowserComponent browser = null;
    protected Text source = null;
    protected CTabItem browserItem = null;
    protected CTabItem sourceItem = null;
    protected Boolean localEdit = false;
    private IAction backAction;
    private IAction forwardAction;
    private IAction refreshAction;
    List<WeakReference<Resource>> history = new ArrayList<WeakReference<Resource>>();
    int historyIndex = 0;

    private CTabItem createItem(int index, Control control) {
        CTabItem item = new CTabItem(this.getTabFolder(), 0, index);
        item.setControl(control);
        return item;
    }

    private CTabFolder getTabFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeChanges() {
        try {
            try {
                String string = this.markup;
                synchronized (string) {
                    this.localEdit = true;
                    System.out.println("writeChanges()");
                    this.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                            Statement stm = graph.getPossibleStatement(WikiEditor.this.getInputResource(), DOC.WikiDocument_wikiText);
                            graph.claimLiteral(WikiEditor.this.getInputResource(), stm.getPredicate(), (Object)new String(WikiEditor.this.markup));
                        }
                    });
                }
            }
            catch (DatabaseException e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
                this.localEdit = false;
            }
        }
        finally {
            this.localEdit = false;
        }
    }

    @Override
    public synchronized void navigate(URL url, String target) {
        String actualURI = url.toExternalForm();
        try {
            while (this.history.size() > this.historyIndex) {
                this.history.remove(this.historyIndex);
            }
            this.history.add(new WeakReference<Resource>(this.getInputResource()));
            this.historyIndex = this.history.size();
            Resource resource = (Resource)SimanticsUI.getSession().syncRequest(Queries.resource((String)actualURI));
            ResourceEditorInput i = new ResourceEditorInput(EDITOR_ID, resource);
            i.init(null);
            this.setInput((IEditorInput)i);
            this.updateActionStates();
        }
        catch (DatabaseException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        this.loadInputResource();
    }

    public synchronized void historyBack() {
        if (this.historyIndex == 0) {
            return;
        }
        if (this.historyIndex == this.history.size()) {
            this.history.add(new WeakReference<Resource>(this.getInputResource()));
        }
        --this.historyIndex;
        WeakReference<Resource> r = this.history.get(this.historyIndex);
        if (!r.isEnqueued()) {
            ResourceEditorInput i = new ResourceEditorInput(EDITOR_ID, (Resource)r.get());
            try {
                i.init(null);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.setInput((IEditorInput)i);
        }
        this.loadInputResource();
    }

    public synchronized void historyForward() {
        if (this.history.size() - 1 < this.historyIndex + 1) {
            return;
        }
        ++this.historyIndex;
        WeakReference<Resource> r = this.history.get(this.historyIndex);
        if (!r.isEnqueued()) {
            ResourceEditorInput i = new ResourceEditorInput(EDITOR_ID, (Resource)r.get());
            try {
                i.init(null);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.setInput((IEditorInput)i);
        }
        this.loadInputResource();
    }

    private void updateActionStates() {
        this.backAction.setEnabled(this.historyIndex > 0);
        this.forwardAction.setEnabled(this.history.size() - 1 >= this.historyIndex + 1);
    }

    public void createPartControl(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        WikiPrintAction printAction = new WikiPrintAction(this);
        WikiExportPDFAction exportAction = new WikiExportPDFAction(this);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)printAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.EXPORT.getId(), (IAction)exportAction);
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        Composite bar = new Composite(parent, 0);
        bar.setLayout((Layout)new GridLayout(3, false));
        bar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bar.setBackground(Display.getCurrent().getSystemColor(1));
        this.backAction = new BackAction();
        this.forwardAction = new ForwardAction();
        this.refreshAction = new RefreshAction();
        new ActionContributionItem(this.backAction).fill(bar);
        new ActionContributionItem(this.forwardAction).fill(bar);
        new ActionContributionItem(this.refreshAction).fill(bar);
        this.folder = new CTabFolder(parent, 0x800400);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser = new BrowserComponent((Composite)this.folder, 0x800800, this);
        this.browser.syncPopulate();
        Logger.getLogger("org.lobobrowser").setLevel(Level.OFF);
        Logger.getLogger("com.steadystate").setLevel(Level.OFF);
        this.source = new Text((Composite)this.folder, 8391234);
        this.source.addModifyListener(new ModifyListener(){
            String latest = null;
            long lastUpdate = 0L;
            Thread t = null;
            Runnable writeTask = new Runnable(){
                long lastWrite = 0L;

                @Override
                public void run() {
                    while (!WikiEditor.this.disposed) {
                        try {
                            Thread.sleep(2000L);
                            long now = System.nanoTime();
                            if (latest == null) {
                                latest = (this).WikiEditor.this.markup;
                            }
                            if ((this).WikiEditor.this.markup.equals(latest) || now - lastUpdate < 2000000000L && now - this.lastWrite < 705032704L) continue;
                            latest = (this).WikiEditor.this.markup;
                            WikiEditor.this.writeChanges();
                            this.lastWrite = System.nanoTime();
                        }
                        catch (InterruptedException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                if (this.t == null) {
                    this.t = new Thread(this.writeTask, "Wiki Edit Tracker");
                    this.t.start();
                }
                String string = WikiEditor.this.markup;
                synchronized (string) {
                    this.lastUpdate = System.nanoTime();
                    WikiEditor.this.markup = WikiEditor.this.source.getText();
                }
            }
        });
        WikiFontUtil.attachControlFontToRegistry(this.resourceManager, (Control)this.source, "org.simantics.wiki.sourcefont");
        this.sourceItem = this.createItem(0, (Control)this.source);
        this.browserItem = this.createItem(1, (Control)this.browser);
        this.sourceItem.setText("Source");
        this.browserItem.setText(DOCUMENT_TAB_TITLE);
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.wiki.ui");
        String selectedTab = prefs.get(PROP_PREVIOUSLY_SELECTED_TAB, "Source");
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (selectedTab.equals(item.getText())) {
                this.folder.setSelection(item);
            }
            ++n2;
        }
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item == WikiEditor.this.browserItem) {
                    WikiEditor.this.writeChanges();
                    WikiEditor.this.updateBrowserView();
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.loadInputResource();
        this.updateActionStates();
        this.folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    prefs.put(WikiEditor.PROP_PREVIOUSLY_SELECTED_TAB, WikiEditor.this.folder.getSelection().getText());
                    prefs.flush();
                }
                catch (BackingStoreException ex) {
                    ErrorLogger.defaultLogError((Throwable)ex);
                }
            }
        });
    }

    protected static String readDocuments(ReadGraph graph, Resource root, int depth) throws ManyObjectsForFunctionalRelationException, ServiceException, BindingException {
        String doc;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(root, L0.HasLabel, (Binding)Bindings.STRING);
        if (name == null) {
            name = (String)graph.getPossibleRelatedValue(root, L0.HasName, (Binding)Bindings.STRING);
        }
        if ((doc = (String)graph.getPossibleRelatedValue(root, DOC.WikiDocument_wikiText, (Binding)Bindings.STRING)) == null) {
            doc = "";
        }
        String header = "";
        int i = 0;
        while (i <= depth && i < 5) {
            header = String.valueOf(header) + "=";
            ++i;
        }
        Collection children = graph.getObjects(root, L0.ConsistsOf);
        for (Resource child : children) {
            String tmp = WikiEditor.readDocuments(graph, child, ++depth);
            if (tmp.length() <= 0) continue;
            doc = String.valueOf(doc) + "\n" + tmp;
        }
        if (name != null && doc.length() > 0) {
            doc = String.valueOf(header) + name + header + "\n" + doc + "\n";
        }
        return doc;
    }

    protected void loadInputResource() {
        final Session session = this.getSession();
        final Resource input = this.getInputResource();
        this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WikiEditor.this.setPartName(WikiEditor.this.getEditorInput().getName());
                try {
                    String uri = (String)SimanticsUI.getSession().syncRequest((Read)new ResourceToPossibleURI(input));
                    if (uri == null) {
                        uri = "";
                    }
                    WikiEditor.this.setContentDescription(uri);
                }
                catch (DatabaseException e) {
                    WikiEditor.this.setContentDescription("");
                }
            }
        });
        try {
            final DocumentResource DOC = DocumentResource.getInstance((RequestProcessor)session);
            session.syncRequest((AsyncRead)new PossibleRelatedValue(input, DOC.WikiDocument_wikiText, (Binding)Bindings.STRING), (Listener)new Listener<String>(){

                public void execute(String sourceMarkup) {
                    if (sourceMarkup == null) {
                        session.asyncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                String template = "";
                                try {
                                    DocumentFactory provider = (DocumentFactory)graph.adapt(input, DocumentFactory.class);
                                    template = provider.createDocument();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                graph.claimLiteral(input, DOC.WikiDocument_wikiText, (Object)template);
                            }
                        });
                    } else {
                        WikiEditor.this.markup = sourceMarkup;
                        if (!WikiEditor.this.localEdit.booleanValue()) {
                            WikiEditor.this.browser.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).WikiEditor.this.source.isDisposed()) {
                                        return;
                                    }
                                    String existing = (this).WikiEditor.this.source.getText();
                                    if (!existing.equals((this).WikiEditor.this.markup)) {
                                        (this).WikiEditor.this.source.setText((this).WikiEditor.this.markup);
                                    }
                                }
                            });
                            WikiEditor.this.updateBrowserView();
                        }
                    }
                }

                public boolean isDisposed() {
                    return WikiEditor.this.browser.isDisposed();
                }

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected void updateBrowserView() {
        try {
            String finalMarkup = SimanticsDialect.INSTANCE.apply(null, null, this.markup);
            MarkupParser markupParser = new MarkupParser();
            MediaWikiLanguage language = new MediaWikiLanguage();
            markupParser.setMarkupLanguage((MarkupLanguage)language);
            final String htmlContent = markupParser.parseToHtml(finalMarkup);
            if (this.browser != null) {
                this.browser.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WikiEditor.this.browser.setText(htmlContent);
                    }
                });
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Document document, PdfWriter writer) throws DocumentException {
        if (this.folder.getSelection() == this.sourceItem) {
            String string = this.markup;
            synchronized (string) {
                document.add((Element)new Paragraph(this.markup));
            }
        } else {
            PdfContentByte cb = writer.getDirectContent();
            ((RBlock)this.browser.getPanel().getBlockRenderable()).layout((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight(), false, true, 4, 4, false);
            Rectangle bounds = ((RBlock)this.browser.getPanel().getBlockRenderable()).getBounds();
            org.eclipse.swt.graphics.Rectangle browserBounds = this.browser.getBounds();
            this.browser.setBounds(0, 0, (int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight());
            this.browser.getPanel().getBlockRenderable().relayout();
            PdfTemplate template = null;
            int page = 0;
            while ((double)page < Math.floor((double)((float)bounds.height / PageSize.A4.getHeight()) + 0.99)) {
                template = cb.createTemplate(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                Graphics2D g2d = template.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                this.browser.getPanel().getBlockRenderable().setOrigin(0, (int)((float)(-page) * PageSize.A4.getHeight()));
                this.browser.getPanel().getBlockRenderable().paintTranslated((Graphics)g2d);
                g2d.dispose();
                cb.addTemplate(template, 0.0f, 0.0f);
                document.newPage();
                ++page;
            }
            this.browser.setBounds(browserBounds);
        }
    }

    @Override
    public void print(final Printer printer) {
        if (this.folder.getSelection() == this.sourceItem) {
            this.source.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Point screenDPI = WikiEditor.this.source.getDisplay().getDPI();
                    Point printerDPI = printer.getDPI();
                    float scaleX = printerDPI.x / screenDPI.x;
                    float scaleY = printerDPI.y / screenDPI.y;
                    GC pgc = new GC((Drawable)printer);
                    printer.startJob("wiki");
                    printer.startPage();
                    Transform transform = new Transform((Device)printer);
                    pgc.getTransform(transform);
                    transform.scale(scaleX, scaleY);
                    pgc.setTransform(transform);
                    WikiEditor.this.source.print(pgc);
                    printer.endPage();
                    printer.endJob();
                    pgc.dispose();
                    printer.dispose();
                }
            });
        } else {
            this.browser.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Point size = WikiEditor.this.browser.getSize();
                    Image image = new Image((Device)WikiEditor.this.browser.getDisplay(), size.x, size.y);
                    GC gc = new GC((Drawable)WikiEditor.this.browser);
                    gc.copyArea(image, 0, 0);
                    gc.dispose();
                    Point screenDPI = WikiEditor.this.browser.getDisplay().getDPI();
                    Point printerDPI = printer.getDPI();
                    float scaleX = printerDPI.x / screenDPI.x;
                    float scaleY = printerDPI.y / screenDPI.y;
                    ImageData imageData = image.getImageData();
                    Image printImage = new Image((Device)printer, imageData);
                    printer.startJob("wiki");
                    printer.startPage();
                    GC pgc = new GC((Drawable)printer);
                    Transform transform = new Transform((Device)printer);
                    pgc.getTransform(transform);
                    transform.scale(scaleX, scaleY);
                    pgc.setTransform(transform);
                    pgc.drawImage(printImage, 0, 0);
                    printer.endPage();
                    printer.endJob();
                    printer.dispose();
                    pgc.dispose();
                    image.dispose();
                    printImage.dispose();
                }
            });
        }
    }

    class BackAction
    extends Action {
        public BackAction() {
            super("Back", 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            WikiEditor.this.historyBack();
            WikiEditor.this.updateActionStates();
        }
    }

    class ForwardAction
    extends Action {
        public ForwardAction() {
            super("Forward", 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            WikiEditor.this.historyForward();
            WikiEditor.this.updateActionStates();
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            super("Refresh", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.wiki.ui", (String)"icons/arrow_refresh_small.png"));
        }

        public void run() {
            WikiEditor.this.updateBrowserView();
        }
    }
}

