/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class NewDocumentTemplateHandler
extends AbstractHandler {
    private Resource template = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Resource container = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class);
        if (container == null) {
            return null;
        }
        this.template = null;
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    if (!graph.hasStatement(container, DOC.HasDocumentTemplate)) {
                        NewDocumentTemplateHandler.this.template = GraphUtils.create2((WriteGraph)graph, (Resource)DOC.DocumentTemplate, (Object[])new Object[]{DOC.HasDocumentation, "===Template==="});
                        graph.claim(container, DOC.HasDocumentTemplate, NewDocumentTemplateHandler.this.template);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        if (this.template != null) {
            this.openEditor(this.template);
        }
        return null;
    }

    protected void openEditor(Resource resource) {
        try {
            WorkbenchUtils.openEditor((String)"org.simantics.wiki.ui.editor", (IEditorInput)new ResourceEditorInput("org.simantics.wiki.ui.editor", resource));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

