/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.browser;

import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Urls;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.ui.SimanticsUI;
import org.w3c.dom.Document;

public class SimanticsHttpRequest
implements HttpRequest {
    public final UserAgentContext context;
    private final AtomicInteger asyncCounter;
    protected int state = 0;
    protected SimanticsHttpResponse response = null;
    protected boolean isAsync = false;
    protected URL requestUrl = null;
    private final EventDispatch readyEvent = new EventDispatch();

    public SimanticsHttpRequest(UserAgentContext context, AtomicInteger asyncCounter) {
        this.context = context;
        this.asyncCounter = asyncCounter;
    }

    public void abort() {
    }

    public void addReadyStateChangeListener(final ReadyStateChangeListener listener) {
        this.readyEvent.addListener(new GenericEventListener(){

            public void processEvent(EventObject event) {
                listener.readyStateChanged();
            }
        });
    }

    public String getAllResponseHeaders() {
        return null;
    }

    public int getReadyState() {
        return this.state;
    }

    public byte[] getResponseBytes() {
        if (this.response == null) {
            return null;
        }
        return this.response.bytes;
    }

    public String getResponseHeader(String headerName) {
        if (this.response == null || this.response.headers == null) {
            return null;
        }
        return this.response.headers.get(headerName);
    }

    public Image getResponseImage() {
        if (this.response == null) {
            return null;
        }
        String text = this.getResponseText();
        if (text.startsWith("<?xml")) {
            SVGUniverse univ = new SVGUniverse();
            try {
                BufferedImage bufferedImage = ScenegraphUtils.loadSVG((SVGUniverse)univ, (String)text, (int)1000);
                return bufferedImage;
            }
            catch (SVGException e) {
                return null;
            }
            finally {
                univ.clear();
            }
        }
        return Toolkit.getDefaultToolkit().createImage(this.response.bytes);
    }

    public String getResponseText() {
        if (this.response == null) {
            return null;
        }
        String encoding = "UTF-8";
        try {
            return this.response == null ? null : new String(this.response.bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public Document getResponseXML() {
        if (this.response == null || this.response.bytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.response.bytes);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception err) {
            return null;
        }
    }

    public int getStatus() {
        if (this.response == null) {
            return 0;
        }
        return this.response.status;
    }

    public String getStatusText() {
        if (this.response == null) {
            return "";
        }
        return "" + this.response.status;
    }

    public void open(String method, String url) throws IOException {
        this.open(method, url, true);
    }

    public void open(String method, URL url) throws IOException {
        this.open(method, url, true, null, null);
    }

    public void open(String method, URL url, boolean asyncFlag) throws IOException {
        this.open(method, url, asyncFlag, null, null);
    }

    public void open(String method, String url, boolean asyncFlag) throws IOException {
        this.open(method, Urls.createURL(null, (String)url), asyncFlag, null);
    }

    public void open(String method, URL url, boolean asyncFlag, String userName) throws IOException {
        this.open(method, url, asyncFlag, userName, null);
    }

    public void open(String method, URL url, boolean asyncFlag, String userName, String password) throws IOException {
        this.abort();
        System.out.println("open");
        this.isAsync = asyncFlag;
        this.requestUrl = url;
        this.state = 1;
    }

    public void send(String content) throws IOException {
        if (this.isAsync) {
            this.asyncCounter.incrementAndGet();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SimanticsHttpRequest.this.sendImpl();
                    SimanticsHttpRequest.this.asyncCounter.decrementAndGet();
                }
            };
            Simantics.async((Runnable)r);
        } else {
            this.sendImpl();
        }
    }

    protected void sendImpl() {
        String url = this.requestUrl.toExternalForm();
        try {
            Session session = SimanticsUI.getSession();
            final Resource resource = (Resource)session.syncRequest(Queries.resource((String)url));
            if (resource == null) {
                System.out.println("resource is null");
                return;
            }
            session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    ImageResource IMAGE = ImageResource.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(resource, IMAGE.SvgImage)) {
                        String data = (String)graph.getValue(resource, (Binding)Bindings.STRING);
                        SimanticsHttpRequest.this.response = new SimanticsHttpResponse(data.getBytes(), 200, new HashMap<String, String>());
                    } else if (graph.isInstanceOf(resource, IMAGE.Image)) {
                        byte[] data = (byte[])graph.getValue(resource, (Binding)Bindings.BYTE_ARRAY);
                        SimanticsHttpRequest.this.response = new SimanticsHttpResponse(data, 200, new HashMap<String, String>());
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.state = 2;
        this.state = 3;
        this.state = 4;
        this.readyEvent.fireEvent(null);
    }

    public static class SimanticsHttpResponse {
        protected byte[] bytes;
        int status;
        Map<String, String> headers;

        public SimanticsHttpResponse(byte[] bytes, int status, Map<String, String> headers) {
            this.bytes = bytes;
            this.status = status;
            this.headers = headers;
        }
    }
}

