/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.browser;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleBrowserFrame;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.simantics.wiki.ui.browser.SimanticsHttpRequest;
import org.simantics.wiki.ui.editor.NavigationHandler;
import org.simantics.wiki.ui.objects.Renderer;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimanticsHtmlRendererContext
implements HtmlRendererContext {
    protected HtmlPanel htmlPanel;
    protected HtmlRendererContext opener;
    protected HtmlRendererContext parent;
    protected String sourceCode;
    protected String htmlContent = null;
    protected NavigationHandler editor = null;
    protected AtomicInteger asyncCounter = new AtomicInteger(0);
    protected UserAgentContext userAgentContext = new SimanticsUserAgentContext(this.asyncCounter);

    public SimanticsHtmlRendererContext(HtmlPanel htmlPanel, NavigationHandler editor) {
        this.htmlPanel = htmlPanel;
        this.editor = editor;
    }

    public int readAsyncCounter() {
        return this.asyncCounter.get();
    }

    public void alert(String message) {
        JOptionPane.showMessageDialog((Component)this.htmlPanel, message);
    }

    public void back() {
    }

    public void blur() {
    }

    public void close() {
    }

    public boolean confirm(String message) {
        int rval = JOptionPane.showConfirmDialog((Component)this.htmlPanel, message, "Confirm", 0);
        return rval == 0;
    }

    public BrowserFrame createBrowserFrame() {
        return new SimpleBrowserFrame((HtmlRendererContext)this);
    }

    public void focus() {
    }

    public void forward() {
    }

    public String getCurrentURL() {
        NodeImpl node = this.htmlPanel.getRootNode();
        if (node instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)node;
            return doc.getDocumentURI();
        }
        return null;
    }

    public String getDefaultStatus() {
        return "";
    }

    public HTMLCollection getFrames() {
        NodeImpl rootNode = this.htmlPanel.getRootNode();
        if (rootNode instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)rootNode).getFrames();
        }
        return null;
    }

    public int getHistoryLength() {
        return 0;
    }

    public HtmlObject getHtmlObject(HTMLElement element) {
        System.out.println("getHtmlObject(" + element + ")");
        if (element.getNodeName().equals("object")) {
            String className = element.getAttribute("classid");
            try {
                Class<?> classImpl = this.getClass().getClassLoader().loadClass(className);
                Renderer obj = (Renderer)classImpl.newInstance();
                int i = 0;
                while (i < element.getAttributes().getLength()) {
                    String name = element.getAttributes().item(i).getNodeName();
                    String value = element.getAttribute(name);
                    obj.setAttribute(name, value);
                    ++i;
                }
                return obj;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getName() {
        return "";
    }

    public String getNextURL() {
        return null;
    }

    public HtmlRendererContext getOpener() {
        return this.opener;
    }

    public HtmlRendererContext getParent() {
        return this.parent;
    }

    public String getPreviousURL() {
        return null;
    }

    public String getStatus() {
        return "";
    }

    public HtmlRendererContext getTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTop();
    }

    public UserAgentContext getUserAgentContext() {
        return this.userAgentContext;
    }

    public void goToHistoryURL(String url) {
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isImageLoadingEnabled() {
        return true;
    }

    public boolean isVisitedLink(HTMLLinkElement link) {
        return false;
    }

    public void linkClicked(HTMLElement linkNode, URL url, String target) {
        this.navigate(url, target);
    }

    public void moveInHistory(int offset) {
    }

    public void navigate(URL url, String target) {
        this.editor.navigate(url, target);
    }

    public boolean onContextMenu(HTMLElement element, MouseEvent event) {
        return true;
    }

    public boolean onDoubleClick(HTMLElement element, MouseEvent event) {
        return true;
    }

    public boolean onMouseClick(HTMLElement element, MouseEvent event) {
        return true;
    }

    public void onMouseOut(HTMLElement element, MouseEvent event) {
    }

    public void onMouseOver(HTMLElement element, MouseEvent event) {
    }

    public HtmlRendererContext open(String absoluteUrl, String windowName, String windowFeatures, boolean replace) {
        return null;
    }

    public HtmlRendererContext open(URL url, String windowName, String windowFeatures, boolean replace) {
        return null;
    }

    public String prompt(String message, String inputDefault) {
        return JOptionPane.showInputDialog((Component)this.htmlPanel, (Object)message);
    }

    public void reload() {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.htmlPanel.getRootNode();
        if (document != null) {
            try {
                URL url = new URL(document.getDocumentURI());
                this.navigate(url, null);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void resizeBy(int byWidth, int byHeight) {
    }

    public void resizeTo(int width, int height) {
    }

    public void scroll(int x, int y) {
        this.htmlPanel.scroll(x, y);
    }

    public void scrollBy(int x, int y) {
        this.htmlPanel.scrollBy(x, y);
    }

    public void setDefaultStatus(String value) {
    }

    public void setOpener(HtmlRendererContext opener) {
        this.opener = opener;
    }

    public void setStatus(String message) {
    }

    public void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) {
        System.out.println("submitForm(" + method + ", " + action + ")");
        this.sourceCode = null;
        String actualURI = action.toExternalForm();
        DocumentBuilderImpl builder = new DocumentBuilderImpl(this.getUserAgentContext(), (HtmlRendererContext)this);
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.htmlContent.getBytes("UTF-8"));
            HTMLDocumentImpl document = (HTMLDocumentImpl)builder.createDocument((InputSource)new InputSourceImpl((InputStream)bin, actualURI, "UTF-8"));
            this.htmlPanel.setDocument((Document)document, (HtmlRendererContext)this);
            document.load();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String ref = action.getRef();
        if (ref != null && ref.length() != 0) {
            this.htmlPanel.scrollToElement(ref);
        }
        this.sourceCode = this.htmlContent;
    }

    public void render(String html) {
        this.sourceCode = null;
        String actualURI = "http://localhost/";
        DocumentBuilderImpl builder = new DocumentBuilderImpl(this.getUserAgentContext(), (HtmlRendererContext)this);
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(html.getBytes("UTF-8"));
            HTMLDocumentImpl document = (HTMLDocumentImpl)builder.createDocument((InputSource)new InputSourceImpl((InputStream)bin, actualURI, "UTF-8"));
            this.htmlPanel.setDocument((Document)document, (HtmlRendererContext)this);
            document.load();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sourceCode = new String(html);
    }

    public static class SimanticsUserAgentContext
    extends SimpleUserAgentContext {
        private final AtomicInteger asyncCounter;

        SimanticsUserAgentContext(AtomicInteger asyncCounter) {
            this.asyncCounter = asyncCounter;
        }

        public HttpRequest createHttpRequest() {
            return new SimanticsHttpRequest((UserAgentContext)this, this.asyncCounter);
        }
    }
}

