/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.wiki.ui.MarkupTransform;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.objects.DiagramRenderer;
import org.simantics.wiki.ui.objects.TrendRenderer;

public class SimanticsImageDialect
implements MarkupTransform {
    public static final SimanticsImageDialect INSTANCE = new SimanticsImageDialect();
    protected Map<String, BufferedImage> images = new HashMap<String, BufferedImage>();
    private final MarkupTransform[] transforms = new MarkupTransform[]{new TrendTransform(), new DiagramTransform(), new SimanticsDialect.TimestampTransform()};

    public void clearImages() {
        this.images.clear();
    }

    public BufferedImage getImage(String filename) {
        return this.images.get(filename);
    }

    public Map<String, BufferedImage> getImages() {
        return this.images;
    }

    @Override
    public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
        MarkupTransform[] markupTransformArray = this.transforms;
        int n = this.transforms.length;
        int n2 = 0;
        while (n2 < n) {
            MarkupTransform t = markupTransformArray[n2];
            markup = t.apply(graph, variable, markup);
            ++n2;
        }
        return markup;
    }

    class DiagramTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{diagram(?::([^\\}]+))?\\}");

        DiagramTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String options = matcher.group(1);
                HashMap<String, String> params = new HashMap<String, String>();
                if (options != null) {
                    String[] optionPairs;
                    String[] stringArray = optionPairs = options.split("\\s*\\|\\s*");
                    int n = optionPairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String optionPair = stringArray[n2];
                        String[] keyValue = optionPair.split("\\s*=\\s*");
                        if (keyValue.length == 2) {
                            String key = keyValue[0].trim();
                            String value = keyValue[1].trim();
                            params.put(key, value);
                        }
                        ++n2;
                    }
                }
                String filename = String.valueOf(UUID.randomUUID().toString()) + ".png";
                sb.append("[[Image:" + filename + "]]");
                int width = 600;
                int height = 400;
                String data = "resource=" + (String)params.get("resource");
                if (params.containsKey("layer")) {
                    data = String.valueOf(data) + "|layer=" + (String)params.get("layer");
                }
                DiagramRenderer dr = new DiagramRenderer();
                dr.setAttribute("width", "" + width);
                dr.setAttribute("height", "" + height);
                dr.setAttribute("data", data);
                Component c = dr.getComponent();
                BufferedImage img = new BufferedImage(width, height, 1);
                Graphics2D g2d = img.createGraphics();
                c.paintAll(g2d);
                SimanticsImageDialect.this.images.put(filename, img);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }

    class TrendTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{trend(?::([^\\}]+))?\\}");

        TrendTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String options = matcher.group(1);
                HashMap<String, String> params = new HashMap<String, String>();
                if (options != null) {
                    String[] optionPairs;
                    String[] stringArray = optionPairs = options.split("\\s*\\|\\s*");
                    int n = optionPairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String optionPair = stringArray[n2];
                        String[] keyValue = optionPair.split("\\s*=\\s*");
                        if (keyValue.length == 2) {
                            String key = keyValue[0].trim();
                            String value = keyValue[1].trim();
                            params.put(key, value);
                        }
                        ++n2;
                    }
                }
                String filename = String.valueOf(UUID.randomUUID().toString()) + ".png";
                sb.append("[[Image:" + filename + "]]");
                int width = 300;
                int height = 200;
                String title = "Trend";
                String data = (String)params.get("data");
                if (params.containsKey("width")) {
                    width = Integer.parseInt((String)params.get("width"));
                }
                if (params.containsKey("height")) {
                    height = Integer.parseInt((String)params.get("height"));
                }
                if (params.containsKey("title")) {
                    title = (String)params.get("title");
                }
                TrendRenderer tr = new TrendRenderer();
                tr.setAttribute("width", "" + width);
                tr.setAttribute("height", "" + height);
                tr.setAttribute("title", title);
                tr.setAttribute("data", data);
                Component c = tr.getComponent();
                BufferedImage img = new BufferedImage(width, height, 1);
                Graphics2D g2d = img.createGraphics();
                c.doLayout();
                c.paint(g2d);
                SimanticsImageDialect.this.images.put(filename, img);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

